/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.runtime.operators.CrossDriver;
import org.apache.flink.runtime.operators.CrossTaskTest;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.testutils.DriverTestBase;
import org.apache.flink.runtime.operators.testutils.UniformRecordGenerator;
import org.apache.flink.types.Record;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;

class CrossTaskExternalITCase
extends DriverTestBase<CrossFunction<Record, Record, Record>> {
    private static final long CROSS_MEM = 0x100000L;
    private final double cross_frac;
    private final DriverTestBase.CountingOutputCollector output = new DriverTestBase.CountingOutputCollector();

    CrossTaskExternalITCase(ExecutionConfig config) {
        super(config, 0x100000L, 0);
        this.cross_frac = 1048576.0 / (double)this.getMemoryManager().getMemorySize();
    }

    @TestTemplate
    void testExternalBlockCrossTask() {
        int keyCnt1 = 2;
        int valCnt1 = 1;
        int keyCnt2 = 43700;
        int valCnt2 = 1;
        int expCnt = keyCnt1 * valCnt1 * keyCnt2 * valCnt2;
        this.setOutput(this.output);
        this.addInput(new UniformRecordGenerator(keyCnt1, valCnt1, false));
        this.addInput(new UniformRecordGenerator(keyCnt2, valCnt2, false));
        this.getTaskConfig().setDriverStrategy(DriverStrategy.NESTEDLOOP_BLOCKED_OUTER_FIRST);
        this.getTaskConfig().setRelativeMemoryDriver(this.cross_frac);
        CrossDriver testTask = new CrossDriver();
        try {
            this.testDriver((Driver)testTask, CrossTaskTest.MockCrossStub.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Test failed due to an exception.");
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.output.getNumberOfRecords()).withFailMessage("Wrong result size.", new Object[0])).isEqualTo(expCnt);
    }

    @TestTemplate
    void testExternalStreamCrossTask() {
        int keyCnt1 = 2;
        int valCnt1 = 1;
        int keyCnt2 = 87385;
        int valCnt2 = 1;
        int expCnt = keyCnt1 * valCnt1 * keyCnt2 * valCnt2;
        this.setOutput(this.output);
        this.addInput(new UniformRecordGenerator(keyCnt1, valCnt1, false));
        this.addInput(new UniformRecordGenerator(keyCnt2, valCnt2, false));
        this.getTaskConfig().setDriverStrategy(DriverStrategy.NESTEDLOOP_STREAMED_OUTER_FIRST);
        this.getTaskConfig().setRelativeMemoryDriver(this.cross_frac);
        CrossDriver testTask = new CrossDriver();
        try {
            this.testDriver((Driver)testTask, CrossTaskTest.MockCrossStub.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Test failed due to an exception.");
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.output.getNumberOfRecords()).withFailMessage("Wrong result size.", new Object[0])).isEqualTo(expCnt);
    }
}

