/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.AbstractID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TaskManagerGroupTest {
    private MetricRegistryImpl registry;

    TaskManagerGroupTest() {
    }

    @BeforeEach
    void setup() {
        this.registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
    }

    @AfterEach
    void teardown() throws Exception {
        if (this.registry != null) {
            this.registry.closeAsync().get();
        }
    }

    @Test
    void addAndRemoveJobs() {
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"localhost", (ResourceID)ResourceID.generate());
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobVertexID vertex11 = new JobVertexID();
        JobVertexID vertex12 = new JobVertexID();
        JobVertexID vertex13 = new JobVertexID();
        JobVertexID vertex21 = new JobVertexID();
        ExecutionAttemptID execution11 = ExecutionGraphTestUtils.createExecutionAttemptId(vertex11, 17, 0);
        ExecutionAttemptID execution12 = ExecutionGraphTestUtils.createExecutionAttemptId(vertex12, 13, 1);
        ExecutionAttemptID execution13 = ExecutionGraphTestUtils.createExecutionAttemptId(vertex13, 0, 0);
        ExecutionAttemptID execution21 = ExecutionGraphTestUtils.createExecutionAttemptId(vertex21, 7, 2);
        TaskMetricGroup tmGroup11 = group.addJob(jid1, "testjob").addTask(execution11, "test");
        TaskMetricGroup tmGroup12 = group.addJob(jid1, "testjob").addTask(execution12, "test");
        TaskMetricGroup tmGroup21 = group.addJob(jid2, "anotherJob").addTask(execution21, "test");
        Assertions.assertThat((int)group.numRegisteredJobMetricGroups()).isEqualTo(2);
        Assertions.assertThat((boolean)tmGroup11.parent().isClosed()).isFalse();
        Assertions.assertThat((boolean)tmGroup12.parent().isClosed()).isFalse();
        Assertions.assertThat((boolean)tmGroup21.parent().isClosed()).isFalse();
        tmGroup11.close();
        tmGroup21.close();
        Assertions.assertThat((boolean)tmGroup11.isClosed()).isTrue();
        Assertions.assertThat((boolean)tmGroup21.isClosed()).isTrue();
        Assertions.assertThat((boolean)tmGroup11.parent().isClosed()).isFalse();
        Assertions.assertThat((boolean)tmGroup12.parent().isClosed()).isFalse();
        Assertions.assertThat((boolean)tmGroup21.parent().isClosed()).isFalse();
        Assertions.assertThat((int)group.numRegisteredJobMetricGroups()).isEqualTo(2);
        TaskMetricGroup tmGroup13 = group.addJob(jid1, "testjob").addTask(execution13, "test");
        Assertions.assertThat((Object)tmGroup11.parent()).isSameAs((Object)tmGroup13.parent());
        tmGroup12.close();
        tmGroup13.close();
    }

    @Test
    void testCloseClosesAll() {
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"localhost", (ResourceID)new ResourceID(new AbstractID().toString()));
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobVertexID vertex11 = new JobVertexID();
        JobVertexID vertex12 = new JobVertexID();
        JobVertexID vertex21 = new JobVertexID();
        ExecutionAttemptID execution11 = ExecutionGraphTestUtils.createExecutionAttemptId(vertex11, 17, 0);
        ExecutionAttemptID execution12 = ExecutionGraphTestUtils.createExecutionAttemptId(vertex12, 13, 1);
        ExecutionAttemptID execution21 = ExecutionGraphTestUtils.createExecutionAttemptId(vertex21, 7, 1);
        TaskMetricGroup tmGroup11 = group.addJob(jid1, "testjob").addTask(execution11, "test");
        TaskMetricGroup tmGroup12 = group.addJob(jid1, "testjob").addTask(execution12, "test");
        TaskMetricGroup tmGroup21 = group.addJob(jid2, "anotherJob").addTask(execution21, "test");
        group.close();
        Assertions.assertThat((boolean)tmGroup11.isClosed()).isTrue();
        Assertions.assertThat((boolean)tmGroup12.isClosed()).isTrue();
        Assertions.assertThat((boolean)tmGroup21.isClosed()).isTrue();
    }

    @Test
    void testGenerateScopeDefault() {
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"localhost", (ResourceID)new ResourceID("id"));
        Assertions.assertThat((Object[])group.getScopeComponents()).containsExactly((Object[])new String[]{"localhost", "taskmanager", "id"});
        Assertions.assertThat((String)group.getMetricIdentifier("name")).isEqualTo("localhost.taskmanager.id.name");
    }

    @Test
    void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_TM, (Object)"constant.<host>.foo.<host>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        Assertions.assertThat((Object[])group.getScopeComponents()).containsExactly((Object[])new String[]{"constant", "host", "foo", "host"});
        Assertions.assertThat((String)group.getMetricIdentifier("name")).isEqualTo("constant.host.foo.host.name");
        registry.closeAsync().get();
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"host", (ResourceID)new ResourceID("id"));
        QueryScopeInfo.TaskManagerQueryScopeInfo info = tm.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.taskManagerID).isEqualTo("id");
    }
}

