/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.messages.GenericMessageTester;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.JobIdsWithStatusOverview;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.messages.webmonitor.RequestJobDetails;
import org.apache.flink.runtime.messages.webmonitor.RequestJobsOverview;
import org.apache.flink.runtime.messages.webmonitor.RequestJobsWithIDsOverview;
import org.apache.flink.runtime.messages.webmonitor.RequestStatusOverview;
import org.junit.jupiter.api.Test;

class WebMonitorMessagesTest {
    WebMonitorMessagesTest() {
    }

    @Test
    void testStatusMessages() throws Exception {
        Random rnd = new Random();
        GenericMessageTester.testMessageInstance((Serializable)RequestJobsOverview.getInstance());
        GenericMessageTester.testMessageInstance((Serializable)RequestJobsWithIDsOverview.getInstance());
        GenericMessageTester.testMessageInstance((Serializable)RequestStatusOverview.getInstance());
        GenericMessageTester.testMessageInstance((Serializable)RequestJobsOverview.getInstance());
        GenericMessageTester.testMessageInstance((Serializable)GenericMessageTester.instantiateGeneric(RequestJobDetails.class, rnd, new GenericMessageTester.Instantiator[0]));
        GenericMessageTester.testMessageInstance((Serializable)GenericMessageTester.instantiateGeneric(ClusterOverview.class, rnd, new GenericMessageTester.Instantiator[0]));
        GenericMessageTester.testMessageInstance((Serializable)GenericMessageTester.instantiateGeneric(JobsOverview.class, rnd, new GenericMessageTester.Instantiator[0]));
        GenericMessageTester.testMessageInstance((Serializable)new JobIdsWithStatusOverview(Arrays.asList(new JobIdsWithStatusOverview.JobIdWithStatus(JobID.generate(), JobStatus.RUNNING), new JobIdsWithStatusOverview.JobIdWithStatus(JobID.generate(), JobStatus.CANCELED), new JobIdsWithStatusOverview.JobIdWithStatus(JobID.generate(), JobStatus.CREATED), new JobIdsWithStatusOverview.JobIdWithStatus(JobID.generate(), JobStatus.FAILED), new JobIdsWithStatusOverview.JobIdWithStatus(JobID.generate(), JobStatus.RESTARTING))));
    }

    @Test
    void testJobDetailsMessage() throws Exception {
        Random rnd = new Random();
        int[] numVerticesPerState = new int[ExecutionState.values().length];
        int numTotal = 0;
        for (int i = 0; i < numVerticesPerState.length; ++i) {
            int count;
            numVerticesPerState[i] = count = rnd.nextInt(55);
            numTotal += count;
        }
        long time = rnd.nextLong();
        long endTime = rnd.nextBoolean() ? -1L : time + (long)rnd.nextInt();
        long lastModified = endTime == -1L ? time + (long)rnd.nextInt() : endTime;
        String name = GenericMessageTester.randomString(rnd);
        JobID jid = GenericMessageTester.randomJobId(rnd);
        JobStatus status = GenericMessageTester.randomJobStatus(rnd);
        JobDetails msg1 = new JobDetails(jid, name, time, endTime, endTime - time, status, lastModified, numVerticesPerState, numTotal);
        JobDetails msg2 = new JobDetails(jid, name, time, endTime, endTime - time, status, lastModified, numVerticesPerState, numTotal);
        GenericMessageTester.testMessageInstances((Serializable)msg1, (Serializable)msg2);
    }

    @Test
    void testMultipleJobDetails() throws Exception {
        Random rnd = new Random();
        GenericMessageTester.testMessageInstance((Serializable)new MultipleJobsDetails(this.randomJobDetails(rnd)));
    }

    private Collection<JobDetails> randomJobDetails(Random rnd) {
        JobDetails[] details = new JobDetails[rnd.nextInt(10)];
        for (int k = 0; k < details.length; ++k) {
            int[] numVerticesPerState = new int[ExecutionState.values().length];
            int numTotal = 0;
            for (int i = 0; i < numVerticesPerState.length; ++i) {
                int count;
                numVerticesPerState[i] = count = rnd.nextInt(55);
                numTotal += count;
            }
            long time = rnd.nextLong();
            long endTime = rnd.nextBoolean() ? -1L : time + (long)rnd.nextInt();
            long lastModified = endTime == -1L ? time + (long)rnd.nextInt() : endTime;
            String name = new GenericMessageTester.StringInstantiator().instantiate(rnd);
            JobID jid = new JobID();
            JobStatus status = JobStatus.values()[rnd.nextInt(JobStatus.values().length)];
            details[k] = new JobDetails(jid, name, time, endTime, endTime - time, status, lastModified, numVerticesPerState, numTotal);
        }
        return Arrays.asList(details);
    }
}

