/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.function.TriConsumer;
import org.apache.flink.util.function.TriFunction;

public class TestingSlotPoolService
implements SlotPoolService {
    private final JobID jobId;
    private final TriConsumer<? super JobMasterId, ? super String, ? super ComponentMainThreadExecutor> startConsumer;
    private final Runnable closeRunnable;
    private final TriFunction<? super TaskManagerLocation, ? super TaskManagerGateway, ? super Collection<SlotOffer>, ? extends Collection<SlotOffer>> offerSlotsFunction;
    private final TriFunction<? super ResourceID, ? super AllocationID, ? super Exception, Optional<ResourceID>> failAllocationFunction;
    private final Function<? super ResourceID, Boolean> registerTaskManagerFunction;
    private final BiFunction<? super ResourceID, ? super Exception, Boolean> releaseTaskManagerFunction;
    private final Consumer<? super ResourceManagerGateway> connectToResourceManagerConsumer;
    private final Runnable disconnectResourceManagerRunnable;
    private final BiFunction<? super JobID, ? super ResourceID, ? extends AllocatedSlotReport> createAllocatedSlotReportFunction;

    public TestingSlotPoolService(JobID jobId, TriConsumer<? super JobMasterId, ? super String, ? super ComponentMainThreadExecutor> startConsumer, Runnable closeRunnable, TriFunction<? super TaskManagerLocation, ? super TaskManagerGateway, ? super Collection<SlotOffer>, ? extends Collection<SlotOffer>> offerSlotsFunction, TriFunction<? super ResourceID, ? super AllocationID, ? super Exception, Optional<ResourceID>> failAllocationFunction, Function<? super ResourceID, Boolean> registerTaskManagerFunction, BiFunction<? super ResourceID, ? super Exception, Boolean> releaseTaskManagerFunction, Consumer<? super ResourceManagerGateway> connectToResourceManagerConsumer, Runnable disconnectResourceManagerRunnable, BiFunction<? super JobID, ? super ResourceID, ? extends AllocatedSlotReport> createAllocatedSlotReportFunction) {
        this.jobId = jobId;
        this.startConsumer = startConsumer;
        this.closeRunnable = closeRunnable;
        this.offerSlotsFunction = offerSlotsFunction;
        this.failAllocationFunction = failAllocationFunction;
        this.registerTaskManagerFunction = registerTaskManagerFunction;
        this.releaseTaskManagerFunction = releaseTaskManagerFunction;
        this.connectToResourceManagerConsumer = connectToResourceManagerConsumer;
        this.disconnectResourceManagerRunnable = disconnectResourceManagerRunnable;
        this.createAllocatedSlotReportFunction = createAllocatedSlotReportFunction;
    }

    public void start(JobMasterId jobMasterId, String address, ComponentMainThreadExecutor mainThreadExecutor) throws Exception {
        this.startConsumer.accept((Object)jobMasterId, (Object)address, (Object)mainThreadExecutor);
    }

    public void close() {
        this.closeRunnable.run();
    }

    public Collection<SlotOffer> offerSlots(TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, Collection<SlotOffer> offers) {
        return (Collection)this.offerSlotsFunction.apply((Object)taskManagerLocation, (Object)taskManagerGateway, offers);
    }

    public Optional<ResourceID> failAllocation(@Nullable ResourceID taskManagerId, AllocationID allocationId, Exception cause) {
        return (Optional)this.failAllocationFunction.apply((Object)taskManagerId, (Object)allocationId, (Object)cause);
    }

    public boolean registerTaskManager(ResourceID taskManagerId) {
        return this.registerTaskManagerFunction.apply((ResourceID)taskManagerId);
    }

    public boolean releaseTaskManager(ResourceID taskManagerId, Exception cause) {
        return this.releaseTaskManagerFunction.apply((ResourceID)taskManagerId, cause);
    }

    public void releaseFreeSlotsOnTaskManager(ResourceID taskManagerId, Exception cause) {
        throw new UnsupportedOperationException("TestingSlotPoolService does not support this operation.");
    }

    public void connectToResourceManager(ResourceManagerGateway resourceManagerGateway) {
        this.connectToResourceManagerConsumer.accept((ResourceManagerGateway)resourceManagerGateway);
    }

    public void disconnectResourceManager() {
        this.disconnectResourceManagerRunnable.run();
    }

    public AllocatedSlotReport createAllocatedSlotReport(ResourceID taskManagerId) {
        return this.createAllocatedSlotReportFunction.apply((JobID)this.jobId, (ResourceID)taskManagerId);
    }
}

