/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.RpcTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.ResourceCounter;

public final class SlotPoolTestUtils {
    private SlotPoolTestUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }

    public static TaskManagerGateway createTaskManagerGateway(@Nullable TaskExecutorGateway taskExecutorGateway) {
        return new RpcTaskManagerGateway((TaskExecutorGateway)(taskExecutorGateway == null ? new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway() : taskExecutorGateway), JobMasterId.generate());
    }

    @Nonnull
    public static Collection<SlotOffer> offerSlots(DeclarativeSlotPool slotPool, Collection<? extends SlotOffer> slotOffers) {
        return SlotPoolTestUtils.offerSlots(slotPool, slotOffers, SlotPoolTestUtils.createTaskManagerGateway(null));
    }

    @Nonnull
    public static Collection<SlotOffer> offerSlots(DeclarativeSlotPool slotPool, Collection<? extends SlotOffer> slotOffers, TaskManagerLocation taskManagerLocation) {
        return slotPool.offerSlots(slotOffers, taskManagerLocation, SlotPoolTestUtils.createTaskManagerGateway(null), 0L);
    }

    @Nonnull
    public static Collection<SlotOffer> offerSlots(DeclarativeSlotPool slotPool, Collection<? extends SlotOffer> slotOffers, TaskManagerGateway taskManagerGateway) {
        return slotPool.offerSlots(slotOffers, (TaskManagerLocation)new LocalTaskManagerLocation(), taskManagerGateway, 0L);
    }

    @Nonnull
    public static Collection<SlotOffer> offerSlots(SlotPool slotPool, Collection<SlotOffer> slotOffers, TaskManagerGateway taskManagerGateway) {
        return slotPool.offerSlots((TaskManagerLocation)new LocalTaskManagerLocation(), taskManagerGateway, slotOffers);
    }

    @Nonnull
    public static Collection<SlotOffer> createSlotOffersForResourceRequirements(ResourceCounter resourceRequirements) {
        ArrayList<SlotOffer> slotOffers = new ArrayList<SlotOffer>();
        int slotIndex = 0;
        for (Map.Entry resourceWithCount : resourceRequirements.getResourcesWithCount()) {
            for (int i = 0; i < (Integer)resourceWithCount.getValue(); ++i) {
                ResourceProfile slotProfile = (ResourceProfile)resourceWithCount.getKey();
                slotOffers.add(new SlotOffer(new AllocationID(), slotIndex++, slotProfile == ResourceProfile.UNKNOWN ? ResourceProfile.ANY : slotProfile));
            }
        }
        return slotOffers;
    }
}

