/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import org.apache.flink.runtime.jobmaster.event.JobEvent;
import org.apache.flink.runtime.jobmaster.event.JobEventManager;
import org.apache.flink.runtime.jobmaster.event.JobEventReplayHandler;
import org.apache.flink.runtime.jobmaster.event.JobEventStore;
import org.apache.flink.runtime.jobmaster.event.TestingJobEvent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobEventManagerTest {
    JobEventManagerTest() {
    }

    @Test
    void testStartTwice() throws Exception {
        TestingJobEventStore.init();
        JobEventManager jobEventManager = new JobEventManager((JobEventStore)new TestingJobEventStore());
        jobEventManager.start();
        Assertions.assertThat((boolean)jobEventManager.isRunning()).isTrue();
        Assertions.assertThat((int)TestingJobEventStore.startTimes).isEqualTo(1);
        jobEventManager.start();
        Assertions.assertThat((int)TestingJobEventStore.startTimes).isEqualTo(1);
    }

    @Test
    void testStop() throws Exception {
        TestingJobEventStore.init();
        JobEventManager jobEventManager = new JobEventManager((JobEventStore)new TestingJobEventStore());
        jobEventManager.start();
        Assertions.assertThat((boolean)jobEventManager.isRunning()).isTrue();
        jobEventManager.stop(true);
        Assertions.assertThat((boolean)jobEventManager.isRunning()).isFalse();
    }

    @Test
    void testRestart() throws Exception {
        TestingJobEventStore.init();
        JobEventManager jobEventManager = new JobEventManager((JobEventStore)new TestingJobEventStore());
        jobEventManager.start();
        jobEventManager.stop(true);
        Assertions.assertThat((boolean)jobEventManager.isRunning()).isFalse();
        jobEventManager.start();
        Assertions.assertThat((boolean)jobEventManager.isRunning()).isTrue();
    }

    @Test
    void testInvalidInvoke() {
        TestingJobEventStore.init();
        JobEventManager jobEventManager = new JobEventManager((JobEventStore)new TestingJobEventStore());
        Assertions.assertThat((boolean)jobEventManager.isRunning()).isFalse();
        Assertions.assertThatThrownBy(() -> jobEventManager.writeEvent((JobEvent)new TestingJobEvent(0), false)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> jobEventManager.replay(new JobEventReplayHandler(){

            public void startReplay() {
            }

            public void replayOneEvent(JobEvent event) {
            }

            public void finalizeReplay() {
            }
        })).isInstanceOf(IllegalStateException.class);
    }

    public static class TestingJobEventStore
    implements JobEventStore {
        public static int startTimes = 0;

        public void start() {
            ++startTimes;
        }

        public void stop(boolean clear) {
        }

        public void writeEvent(JobEvent jobEvent, boolean cutBlock) {
        }

        public JobEvent readEvent() {
            return null;
        }

        public boolean isEmpty() throws Exception {
            return false;
        }

        public static void init() {
            startTimes = 0;
        }
    }
}

