/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.Arrays;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.testtasks.NoOpInvokable;

public class JobGraphTestUtils {
    public static JobGraph emptyJobGraph() {
        return JobGraphBuilder.newStreamingJobGraphBuilder().build();
    }

    public static JobGraph singleNoOpJobGraph() {
        JobVertex jobVertex = new JobVertex("jobVertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobVertex.setParallelism(1);
        return JobGraphBuilder.newStreamingJobGraphBuilder().addJobVertex(jobVertex).build();
    }

    public static JobGraph streamingJobGraph(JobVertex ... jobVertices) {
        return JobGraphBuilder.newStreamingJobGraphBuilder().addJobVertices(Arrays.asList(jobVertices)).build();
    }

    public static JobGraph batchJobGraph(JobVertex ... jobVertices) {
        return JobGraphBuilder.newBatchJobGraphBuilder().addJobVertices(Arrays.asList(jobVertices)).build();
    }

    private JobGraphTestUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }
}

