/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.junit.Assert;

public interface TestConsumerCallback {
    public void onBuffer(Buffer var1);

    public void onEvent(AbstractEvent var1);

    public static class VerifyAscendingCallback
    extends RecyclingCallback {
        @Override
        public void onBuffer(Buffer buffer) {
            MemorySegment segment = buffer.getMemorySegment();
            int expected = this.getNumberOfReadBuffers() * (segment.size() / 4);
            for (int i = 0; i < segment.size(); i += 4) {
                Assert.assertEquals((long)expected, (long)segment.getInt(i));
                ++expected;
            }
            super.onBuffer(buffer);
        }

        @Override
        public void onEvent(AbstractEvent event) {
            super.onEvent(event);
        }
    }

    public static class RecyclingCallback
    extends CountingCallback {
        @Override
        public void onBuffer(Buffer buffer) {
            super.onBuffer(buffer);
            buffer.recycleBuffer();
        }

        @Override
        public void onEvent(AbstractEvent event) {
            super.onEvent(event);
        }
    }

    public static class CountingCallback
    implements TestConsumerCallback {
        private final AtomicInteger numberOfReadBuffers = new AtomicInteger();
        private final AtomicInteger numberOfReadEvents = new AtomicInteger();

        @Override
        public void onBuffer(Buffer buffer) {
            this.numberOfReadBuffers.incrementAndGet();
        }

        @Override
        public void onEvent(AbstractEvent event) {
            this.numberOfReadEvents.incrementAndGet();
        }

        public int getNumberOfReadBuffers() {
            return this.numberOfReadBuffers.get();
        }

        public int getNumberOfReadEvents() {
            return this.numberOfReadEvents.get();
        }
    }
}

