/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.ArrayDeque;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.testutils.serialization.types.SerializationTestType;
import org.assertj.core.api.Assertions;

public final class DeserializationUtils {
    public static int deserializeRecords(ArrayDeque<SerializationTestType> records, RecordDeserializer<SerializationTestType> deserializer) throws Exception {
        int deserializedRecords = 0;
        while (!records.isEmpty()) {
            SerializationTestType expected = records.poll();
            SerializationTestType actual = (SerializationTestType)expected.getClass().newInstance();
            RecordDeserializer.DeserializationResult result = deserializer.getNextRecord((IOReadableWritable)actual);
            if (result.isFullRecord()) {
                Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
                ++deserializedRecords;
            } else {
                records.addFirst(expected);
            }
            if (!result.isBufferConsumed()) continue;
            break;
        }
        return deserializedRecords;
    }
}

