/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerEntry;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionInfo;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionTracker;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.taskexecutor.partition.ClusterPartitionReport;

public class TestingTaskExecutorPartitionTracker
implements TaskExecutorPartitionTracker {
    private Function<JobID, Boolean> isTrackingPartitionsForFunction = ignored -> false;
    private Function<ResultPartitionID, Boolean> isPartitionTrackedFunction = ignored -> false;
    private Function<JobID, Collection<PartitionTrackerEntry<JobID, TaskExecutorPartitionInfo>>> stopTrackingAllPartitionsFunction = ignored -> Collections.emptySet();
    private Consumer<JobID> stopTrackingAndReleaseAllPartitionsConsumer = ignored -> {};
    private BiConsumer<JobID, TaskExecutorPartitionInfo> startTrackingPartitionsConsumer = (ignoredA, ignoredB) -> {};
    private Consumer<Collection<ResultPartitionID>> stopTrackingAndReleasePartitionsConsumer = ignored -> {};
    private Function<Collection<ResultPartitionID>, Collection<PartitionTrackerEntry<JobID, TaskExecutorPartitionInfo>>> stopTrackingPartitionsFunction = ignored -> Collections.emptySet();
    private Runnable stopTrackingAllClusterPartitionsRunnable = () -> {};
    private Consumer<Collection<ResultPartitionID>> promotePartitionsConsumer = ignored -> {};
    private Consumer<Collection<IntermediateDataSetID>> releaseClusterPartitionsConsumer = ignored -> {};

    public void setStartTrackingPartitionsConsumer(BiConsumer<JobID, TaskExecutorPartitionInfo> startTrackingPartitionsConsumer) {
        this.startTrackingPartitionsConsumer = startTrackingPartitionsConsumer;
    }

    public void setIsTrackingPartitionsForFunction(Function<JobID, Boolean> isTrackingPartitionsForFunction) {
        this.isTrackingPartitionsForFunction = isTrackingPartitionsForFunction;
    }

    public void setIsPartitionTrackedFunction(Function<ResultPartitionID, Boolean> isPartitionTrackedFunction) {
        this.isPartitionTrackedFunction = isPartitionTrackedFunction;
    }

    public void setStopTrackingAllPartitionsFunction(Function<JobID, Collection<PartitionTrackerEntry<JobID, TaskExecutorPartitionInfo>>> stopTrackingAllPartitionsFunction) {
        this.stopTrackingAllPartitionsFunction = stopTrackingAllPartitionsFunction;
    }

    public void setPromotePartitionsConsumer(Consumer<Collection<ResultPartitionID>> promotePartitionsConsumer) {
        this.promotePartitionsConsumer = promotePartitionsConsumer;
    }

    public void setStopTrackingAndReleaseAllPartitionsConsumer(Consumer<JobID> stopTrackingAndReleaseAllPartitionsConsumer) {
        this.stopTrackingAndReleaseAllPartitionsConsumer = stopTrackingAndReleaseAllPartitionsConsumer;
    }

    public void setStopTrackingAndReleasePartitionsConsumer(Consumer<Collection<ResultPartitionID>> stopTrackingAndReleasePartitionsConsumer) {
        this.stopTrackingAndReleasePartitionsConsumer = stopTrackingAndReleasePartitionsConsumer;
    }

    public void setStopTrackingPartitionsFunction(Function<Collection<ResultPartitionID>, Collection<PartitionTrackerEntry<JobID, TaskExecutorPartitionInfo>>> stopTrackingPartitionsFunction) {
        this.stopTrackingPartitionsFunction = stopTrackingPartitionsFunction;
    }

    public void setReleaseClusterPartitionsConsumer(Consumer<Collection<IntermediateDataSetID>> releaseClusterPartitionsConsumer) {
        this.releaseClusterPartitionsConsumer = releaseClusterPartitionsConsumer;
    }

    public void startTrackingPartition(JobID producingJobId, TaskExecutorPartitionInfo partitionInfo) {
        this.startTrackingPartitionsConsumer.accept(producingJobId, partitionInfo);
    }

    public void stopTrackingAndReleaseJobPartitions(Collection<ResultPartitionID> resultPartitionIds) {
        this.stopTrackingAndReleasePartitionsConsumer.accept(resultPartitionIds);
    }

    public void stopTrackingAndReleaseJobPartitionsFor(JobID producingJobId) {
        this.stopTrackingAndReleaseAllPartitionsConsumer.accept(producingJobId);
    }

    public Collection<TaskExecutorPartitionInfo> getTrackedPartitionsFor(JobID producingJobId) {
        return Collections.emptyList();
    }

    public void promoteJobPartitions(Collection<ResultPartitionID> partitionsToPromote) {
        this.promotePartitionsConsumer.accept(partitionsToPromote);
    }

    public void stopTrackingAndReleaseClusterPartitions(Collection<IntermediateDataSetID> dataSetsToRelease) {
        this.releaseClusterPartitionsConsumer.accept(dataSetsToRelease);
    }

    public void stopTrackingAndReleaseAllClusterPartitions() {
        this.stopTrackingAllClusterPartitionsRunnable.run();
    }

    public ClusterPartitionReport createClusterPartitionReport() {
        return new ClusterPartitionReport(Collections.emptyList());
    }

    public Collection<PartitionTrackerEntry<JobID, TaskExecutorPartitionInfo>> stopTrackingPartitionsFor(JobID key) {
        return this.stopTrackingAllPartitionsFunction.apply(key);
    }

    public Collection<PartitionTrackerEntry<JobID, TaskExecutorPartitionInfo>> stopTrackingPartitions(Collection<ResultPartitionID> resultPartitionIds) {
        return this.stopTrackingPartitionsFunction.apply(resultPartitionIds);
    }

    public boolean isTrackingPartitionsFor(JobID key) {
        return this.isTrackingPartitionsForFunction.apply(key);
    }

    public boolean isPartitionTracked(ResultPartitionID resultPartitionID) {
        return this.isPartitionTrackedFunction.apply(resultPartitionID);
    }
}

