/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.CancelPartitionRequestTest;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.testutils.TestingUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ServerTransportErrorHandlingTest {
    ServerTransportErrorHandlingTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRemoteClose() throws Exception {
        TestPooledBufferProvider outboundBuffers = new TestPooledBufferProvider(16);
        CountDownLatch sync = new CountDownLatch(1);
        ResultPartitionManager partitionManager = (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class);
        Mockito.when((Object)partitionManager.createSubpartitionViewOrRegisterListener((ResultPartitionID)ArgumentMatchers.any(ResultPartitionID.class), (ResultSubpartitionIndexSet)ArgumentMatchers.any(ResultSubpartitionIndexSet.class), (BufferAvailabilityListener)ArgumentMatchers.any(BufferAvailabilityListener.class), (PartitionRequestListener)ArgumentMatchers.any(PartitionRequestListener.class))).thenAnswer(invocationOnMock -> Optional.of(new CancelPartitionRequestTest.InfiniteSubpartitionView(outboundBuffers, sync)));
        NettyProtocol protocol = new NettyProtocol((ResultPartitionProvider)partitionManager, (TaskEventPublisher)Mockito.mock(TaskEventDispatcher.class)){

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[]{new NettyMessage.NettyMessageEncoder(), new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ctx.channel().close();
                    }
                }};
            }
        };
        NettyTestUtil.NettyServerAndClient serverAndClient = null;
        try {
            serverAndClient = NettyTestUtil.initServerAndClient(protocol);
            Channel ch = NettyTestUtil.connect(serverAndClient);
            ch.writeAndFlush((Object)new NettyMessage.PartitionRequest(new ResultPartitionID(), new ResultSubpartitionIndexSet(0), new InputChannelID(), Integer.MAX_VALUE));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)sync.await(TestingUtils.TESTING_DURATION.toMillis(), TimeUnit.MILLISECONDS)).withFailMessage("Timed out after waiting for " + TestingUtils.TESTING_DURATION.toMillis() + " ms to be notified about released partition.", new Object[0])).isTrue();
        }
        finally {
            NettyTestUtil.shutdown(serverAndClient);
        }
    }
}

