/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.List;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.AbstractCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.types.Record;
import org.apache.flink.util.Preconditions;

public class RecordCollectingResultPartitionWriter
extends AbstractCollectingResultPartitionWriter {
    private final List<Record> output;
    private final Record record = new Record();
    private final RecordDeserializer<Record> deserializer = new SpillingAdaptiveSpanningRecordDeserializer(new String[]{System.getProperty("java.io.tmpdir")});

    public RecordCollectingResultPartitionWriter(List<Record> output) {
        this.output = (List)Preconditions.checkNotNull(output);
    }

    @Override
    protected void deserializeBuffer(Buffer buffer) throws IOException {
        RecordDeserializer.DeserializationResult result;
        this.deserializer.setNextBuffer(buffer);
        do {
            if (!(result = this.deserializer.getNextRecord((IOReadableWritable)this.record)).isFullRecord()) continue;
            this.output.add(this.record.createCopy());
        } while (!result.isBufferConsumed());
    }
}

