/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.cleanup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.dispatcher.cleanup.DefaultResourceCleaner;
import org.apache.flink.runtime.dispatcher.cleanup.GloballyCleanableResource;
import org.apache.flink.runtime.dispatcher.cleanup.LocallyCleanableResource;
import org.apache.flink.runtime.dispatcher.cleanup.ResourceCleaner;
import org.apache.flink.runtime.dispatcher.cleanup.ResourceCleanerFactory;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingResourceCleanerFactory
implements ResourceCleanerFactory {
    private final Collection<LocallyCleanableResource> locallyCleanableResources;
    private final Collection<GloballyCleanableResource> globallyCleanableResources;
    private final Executor cleanupExecutor;

    private TestingResourceCleanerFactory(Collection<LocallyCleanableResource> locallyCleanableResources, Collection<GloballyCleanableResource> globallyCleanableResources, Executor cleanupExecutor) {
        this.locallyCleanableResources = locallyCleanableResources;
        this.globallyCleanableResources = globallyCleanableResources;
        this.cleanupExecutor = cleanupExecutor;
    }

    public ResourceCleaner createLocalResourceCleaner(ComponentMainThreadExecutor mainThreadExecutor) {
        return this.createResourceCleaner(mainThreadExecutor, this.locallyCleanableResources, LocallyCleanableResource::localCleanupAsync);
    }

    public ResourceCleaner createGlobalResourceCleaner(ComponentMainThreadExecutor mainThreadExecutor) {
        return this.createResourceCleaner(mainThreadExecutor, this.globallyCleanableResources, GloballyCleanableResource::globalCleanupAsync);
    }

    private <T> ResourceCleaner createResourceCleaner(ComponentMainThreadExecutor mainThreadExecutor, Collection<T> resources, DefaultResourceCleaner.CleanupFn<T> cleanupFn) {
        return jobId -> {
            mainThreadExecutor.assertRunningInMainThread();
            Throwable t = null;
            for (Object resource : resources) {
                try {
                    cleanupFn.cleanupAsync(resource, jobId, this.cleanupExecutor).get();
                }
                catch (Throwable throwable) {
                    t = ExceptionUtils.firstOrSuppressed((Throwable)throwable, t);
                }
            }
            return t != null ? FutureUtils.completedExceptionally(t) : FutureUtils.completedVoidFuture();
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Collection<LocallyCleanableResource> locallyCleanableResources = new ArrayList<LocallyCleanableResource>();
        private Collection<GloballyCleanableResource> globallyCleanableResources = new ArrayList<GloballyCleanableResource>();
        private Executor cleanupExecutor = Executors.directExecutor();

        public Builder setLocallyCleanableResources(Collection<LocallyCleanableResource> locallyCleanableResources) {
            this.locallyCleanableResources = locallyCleanableResources;
            return this;
        }

        public Builder withLocallyCleanableResource(LocallyCleanableResource locallyCleanableResource) {
            this.locallyCleanableResources.add(locallyCleanableResource);
            return this;
        }

        public Builder setGloballyCleanableResources(Collection<GloballyCleanableResource> globallyCleanableResources) {
            this.globallyCleanableResources = globallyCleanableResources;
            return this;
        }

        public Builder withGloballyCleanableResource(GloballyCleanableResource globallyCleanableResource) {
            this.globallyCleanableResources.add(globallyCleanableResource);
            return this;
        }

        public Builder setCleanupExecutor(Executor cleanupExecutor) {
            this.cleanupExecutor = cleanupExecutor;
            return this;
        }

        public TestingResourceCleanerFactory build() {
            return new TestingResourceCleanerFactory(this.locallyCleanableResources, this.globallyCleanableResources, this.cleanupExecutor);
        }
    }
}

