/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV4Serializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetadataV4SerializerTest {
    MetadataV4SerializerTest() {
    }

    @Test
    void testSerializeProperties() throws IOException {
        CheckpointMetadata metadata = new CheckpointMetadata(1L, Collections.emptyList(), Collections.emptyList(), CheckpointProperties.forSavepoint((boolean)false, (SavepointFormatType)SavepointFormatType.NATIVE));
        MetadataSerializer instance = MetadataV4Serializer.INSTANCE;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(out);){
            instance.serialize(metadata, dos);
            try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));){
                Assertions.assertThat((Object)instance.deserialize(dis, metadata.getClass().getClassLoader(), "").getCheckpointProperties()).isEqualTo((Object)metadata.getCheckpointProperties());
            }
        }
    }
}

