/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.checkpoint.channel.CheckpointInProgressRequest;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointInProgressRequestTest {
    CheckpointInProgressRequestTest() {
    }

    @Test
    void testNoCancelTwice() throws Exception {
        int i;
        AtomicInteger counter = new AtomicInteger();
        CyclicBarrier barrier = new CyclicBarrier(10);
        CheckpointInProgressRequest request = this.cancelCountingRequest(counter, barrier);
        Thread[] threads = new Thread[barrier.getParties()];
        for (i = 0; i < barrier.getParties(); ++i) {
            threads[i] = new Thread(() -> {
                try {
                    request.cancel((Throwable)new RuntimeException("test"));
                }
                catch (Exception e) {
                    Assertions.fail((String)e.getMessage());
                }
                this.await(barrier);
            });
        }
        for (i = 0; i < barrier.getParties(); ++i) {
            threads[i].start();
            threads[i].join();
        }
        Assertions.assertThat((AtomicInteger)counter).hasValue(1);
    }

    private CheckpointInProgressRequest cancelCountingRequest(AtomicInteger cancelCounter, CyclicBarrier cb) {
        return new CheckpointInProgressRequest("test", new JobVertexID(), 0, 1L, unused -> {}, unused -> {
            cancelCounter.incrementAndGet();
            this.await(cb);
        });
    }

    private void await(CyclicBarrier cb) {
        if (cb.getNumberWaiting() == 0) {
            return;
        }
        try {
            cb.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

