/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;

public class StateHandleDummyUtil {
    public static OperatorStateHandle createNewOperatorStateHandle(int numNamedStates, Random random) {
        HashMap<String, OperatorStateHandle.StateMetaInfo> operatorStateMetaData = new HashMap<String, OperatorStateHandle.StateMetaInfo>(numNamedStates);
        long off = 0L;
        for (int i = 0; i < numNamedStates; ++i) {
            long[] offsets = new long[4];
            for (int o = 0; o < offsets.length; ++o) {
                ++off;
            }
            OperatorStateHandle.StateMetaInfo metaInfo = new OperatorStateHandle.StateMetaInfo(offsets, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE);
            operatorStateMetaData.put(String.valueOf(new UUID(random.nextLong(), random.nextLong())), metaInfo);
        }
        return new OperatorStreamStateHandle(operatorStateMetaData, (StreamStateHandle)StateHandleDummyUtil.createStreamStateHandle(numNamedStates, random));
    }

    private static ByteStreamStateHandle createStreamStateHandle(int numNamedStates, Random random) {
        byte[] streamData = new byte[numNamedStates * 4];
        random.nextBytes(streamData);
        return new ByteStreamStateHandle(String.valueOf(new UUID(random.nextLong(), random.nextLong())), streamData);
    }

    public static KeyedStateHandle createNewKeyedStateHandle(KeyGroupRange keyGroupRange) {
        return new DummyKeyedStateHandle(keyGroupRange);
    }

    public static OperatorStateHandle deepDummyCopy(OperatorStateHandle original) {
        if (original == null) {
            return null;
        }
        ByteStreamStateHandle stateHandleCopy = StateHandleDummyUtil.cloneByteStreamStateHandle((ByteStreamStateHandle)original.getDelegateStateHandle());
        Map offsets = original.getStateNameToPartitionOffsets();
        HashMap<String, OperatorStateHandle.StateMetaInfo> offsetsCopy = new HashMap<String, OperatorStateHandle.StateMetaInfo>(offsets.size());
        for (Map.Entry entry : offsets.entrySet()) {
            OperatorStateHandle.StateMetaInfo metaInfo = (OperatorStateHandle.StateMetaInfo)entry.getValue();
            OperatorStateHandle.StateMetaInfo metaInfoCopy = new OperatorStateHandle.StateMetaInfo(metaInfo.getOffsets(), metaInfo.getDistributionMode());
            offsetsCopy.put(String.valueOf(entry.getKey()), metaInfoCopy);
        }
        return new OperatorStreamStateHandle(offsetsCopy, (StreamStateHandle)stateHandleCopy);
    }

    public static KeyedStateHandle deepDummyCopy(KeyedStateHandle original) {
        if (original == null) {
            return null;
        }
        KeyGroupRange keyGroupRange = original.getKeyGroupRange();
        return new DummyKeyedStateHandle(new KeyGroupRange(keyGroupRange.getStartKeyGroup(), keyGroupRange.getEndKeyGroup()));
    }

    public static InputChannelStateHandle deepDummyCopy(InputChannelStateHandle original) {
        if (original == null) {
            return null;
        }
        return new InputChannelStateHandle(new InputChannelInfo(((InputChannelInfo)original.getInfo()).getGateIdx(), ((InputChannelInfo)original.getInfo()).getInputChannelIdx()), (StreamStateHandle)StateHandleDummyUtil.cloneByteStreamStateHandle((ByteStreamStateHandle)original.getDelegate()), new ArrayList(original.getOffsets()));
    }

    public static ResultSubpartitionStateHandle deepDummyCopy(ResultSubpartitionStateHandle original) {
        if (original == null) {
            return null;
        }
        return new ResultSubpartitionStateHandle(new ResultSubpartitionInfo(((ResultSubpartitionInfo)original.getInfo()).getPartitionIdx(), ((ResultSubpartitionInfo)original.getInfo()).getSubPartitionIdx()), (StreamStateHandle)StateHandleDummyUtil.cloneByteStreamStateHandle((ByteStreamStateHandle)original.getDelegate()), new ArrayList(original.getOffsets()));
    }

    private static ByteStreamStateHandle cloneByteStreamStateHandle(ByteStreamStateHandle delegate) {
        return new ByteStreamStateHandle(String.valueOf(delegate.getHandleName()), (byte[])delegate.getData().clone());
    }

    public static InputChannelStateHandle createNewInputChannelStateHandle(int numNamedStates, Random random) {
        return new InputChannelStateHandle(new InputChannelInfo(0, random.nextInt()), (StreamStateHandle)StateHandleDummyUtil.createStreamStateHandle(numNamedStates, random), StateHandleDummyUtil.genOffsets(numNamedStates, random));
    }

    public static ResultSubpartitionStateHandle createNewResultSubpartitionStateHandle(int numNamedStates, Random random) {
        return new ResultSubpartitionStateHandle(new ResultSubpartitionInfo(random.nextInt(), random.nextInt()), (StreamStateHandle)StateHandleDummyUtil.createStreamStateHandle(numNamedStates, random), StateHandleDummyUtil.genOffsets(numNamedStates, random));
    }

    private static ArrayList<Long> genOffsets(int size, Random random) {
        ArrayList<Long> offsets = new ArrayList<Long>();
        for (int i = 0; i < size; ++i) {
            offsets.add(random.nextLong());
        }
        return offsets;
    }

    public static KeyedStateHandle createKeyedStateHandleFromSeed(int seed) {
        return StateHandleDummyUtil.createNewKeyedStateHandle(KeyGroupRange.of((int)(seed * 4), (int)(seed * 4 + 3)));
    }

    public static OperatorStateHandle createOperatorStateHandleFromSeed(int seed) {
        return StateHandleDummyUtil.createNewOperatorStateHandle(1 + seed % 3, new Random(seed));
    }

    public static InputChannelStateHandle createInputChannelStateHandleFromSeed(int seed) {
        return StateHandleDummyUtil.createNewInputChannelStateHandle(1 + seed % 3, new Random(seed));
    }

    public static ResultSubpartitionStateHandle createResultSubpartitionStateHandleFromSeed(int seed) {
        return StateHandleDummyUtil.createNewResultSubpartitionStateHandle(1 + seed % 3, new Random(seed));
    }

    private static class DummyKeyedStateHandle
    implements KeyedStateHandle {
        private static final long serialVersionUID = 1L;
        private final KeyGroupRange keyGroupRange;
        private final StateHandleID stateHandleId;

        private DummyKeyedStateHandle(KeyGroupRange keyGroupRange) {
            this.keyGroupRange = keyGroupRange;
            this.stateHandleId = StateHandleID.randomStateHandleId();
        }

        public KeyGroupRange getKeyGroupRange() {
            return this.keyGroupRange;
        }

        public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
            return new DummyKeyedStateHandle(this.keyGroupRange.getIntersection(keyGroupRange));
        }

        public StateHandleID getStateHandleId() {
            return this.stateHandleId;
        }

        public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
        }

        public void discardState() throws Exception {
        }

        public long getStateSize() {
            return 0L;
        }

        public long getCheckpointedSize() {
            return this.getStateSize();
        }
    }
}

