/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collection;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptorUtil;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RescaleMappingsTest {
    RescaleMappingsTest() {
    }

    @Test
    void testInvert() {
        RescaleMappings mapping = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(2, 3), InflightDataRescalingDescriptorUtil.to(0, 5));
        RescaleMappings inverted = mapping.invert();
        RescaleMappings expected = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 4), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(4));
        Assertions.assertThat((Object)inverted).isEqualTo((Object)expected);
        Assertions.assertThat((Object)inverted.invert()).isEqualTo((Object)mapping);
    }

    @Test
    void testNormalization() {
        RescaleMappings mapping = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(2, 3), InflightDataRescalingDescriptorUtil.to(0, 5), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]));
        Assertions.assertThat((int)mapping.getNumberOfSources()).isEqualTo(7);
        Assertions.assertThat((int)mapping.getNumberOfTargets()).isEqualTo(6);
        Assertions.assertThat((int[][])mapping.getMappings()).hasNumberOfRows(5);
    }

    @Test
    void testAmbiguousTargets() {
        RescaleMappings mapping = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1, 2), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(2, 3, 4), InflightDataRescalingDescriptorUtil.to(4, 5), InflightDataRescalingDescriptorUtil.to(new int[0]));
        Assertions.assertThat((Collection)mapping.getAmbiguousTargets()).containsExactly((Object[])new Integer[]{2, 4});
    }
}

