/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PrioritizedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PrioritizedOperatorSubtaskStateTest {
    private static final Random RANDOM = new Random(66L);

    PrioritizedOperatorSubtaskStateTest() {
    }

    @Test
    void testTryCreateMixedLocalAndRemoteAlternative() {
        this.testTryCreateMixedLocalAndRemoteAlternative(StateHandleDummyUtil::createKeyedStateHandleFromSeed, KeyedStateHandle::getKeyGroupRange);
    }

    <SH extends StateObject, ID> void testTryCreateMixedLocalAndRemoteAlternative(IntFunction<SH> stateHandleFactory, Function<SH, ID> idExtractor) {
        StateObject remote0 = (StateObject)stateHandleFactory.apply(0);
        StateObject remote1 = (StateObject)stateHandleFactory.apply(1);
        StateObject remote2 = (StateObject)stateHandleFactory.apply(2);
        StateObject remote3 = (StateObject)stateHandleFactory.apply(3);
        List<StateObject> jmState = Arrays.asList(remote0, remote1, remote2, remote3);
        StateObject local0 = (StateObject)stateHandleFactory.apply(0);
        StateObject local3a = (StateObject)stateHandleFactory.apply(3);
        List<StateObject> alternativeA = Arrays.asList(local0, local3a);
        StateObject local1 = (StateObject)stateHandleFactory.apply(1);
        StateObject local3b = (StateObject)stateHandleFactory.apply(3);
        StateObject local5 = (StateObject)stateHandleFactory.apply(5);
        List<StateObject> alternativeB = Arrays.asList(local1, local3b, local5);
        List<StateObjectCollection> alternatives = Arrays.asList(new StateObjectCollection(alternativeA), new StateObjectCollection(Collections.emptyList()), new StateObjectCollection(alternativeB));
        StateObjectCollection result = (StateObjectCollection)PrioritizedOperatorSubtaskState.Builder.tryComputeMixedLocalAndRemoteAlternative((StateObjectCollection)new StateObjectCollection(jmState), alternatives, idExtractor).get();
        Assertions.assertThat((Collection)result).hasSameElementsAs(Arrays.asList(local0, local1, remote2, local3a));
    }

    @Test
    void testTryCreateMixedLocalAndRemoteAlternativeEmptyAlternative() {
        this.testTryCreateMixedLocalAndRemoteAlternativeEmptyAlternative(StateHandleDummyUtil::createKeyedStateHandleFromSeed, KeyedStateHandle::getKeyGroupRange);
    }

    <SH extends StateObject, ID> void testTryCreateMixedLocalAndRemoteAlternativeEmptyAlternative(IntFunction<SH> stateHandleFactory, Function<SH, ID> idExtractor) {
        List<StateObject> jmState = Arrays.asList((StateObject)stateHandleFactory.apply(0), (StateObject)stateHandleFactory.apply(1), (StateObject)stateHandleFactory.apply(2), (StateObject)stateHandleFactory.apply(3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PrioritizedOperatorSubtaskState.Builder.tryComputeMixedLocalAndRemoteAlternative((StateObjectCollection)new StateObjectCollection(jmState), Collections.emptyList(), idExtractor).isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PrioritizedOperatorSubtaskState.Builder.tryComputeMixedLocalAndRemoteAlternative((StateObjectCollection)new StateObjectCollection(jmState), Collections.singletonList(new StateObjectCollection()), idExtractor).isPresent());
    }

    @Test
    void testTryCreateMixedLocalAndRemoteAlternativeEmptyJMState() {
        this.testTryCreateMixedLocalAndRemoteAlternativeEmptyJMState(StateHandleDummyUtil::createKeyedStateHandleFromSeed, KeyedStateHandle::getKeyGroupRange);
    }

    <SH extends StateObject, ID> void testTryCreateMixedLocalAndRemoteAlternativeEmptyJMState(IntFunction<SH> stateHandleFactory, Function<SH, ID> idExtractor) {
        List<StateObject> alternativeA = Arrays.asList((StateObject)stateHandleFactory.apply(0), (StateObject)stateHandleFactory.apply(3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PrioritizedOperatorSubtaskState.Builder.tryComputeMixedLocalAndRemoteAlternative((StateObjectCollection)new StateObjectCollection(Collections.emptyList()), Collections.singletonList(new StateObjectCollection(alternativeA)), idExtractor).isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PrioritizedOperatorSubtaskState.Builder.tryComputeMixedLocalAndRemoteAlternative((StateObjectCollection)new StateObjectCollection(Collections.emptyList()), Collections.emptyList(), KeyedStateHandle::getKeyGroupRange).isPresent());
    }

    @Test
    void testPrioritization() {
        for (int i = 0; i < 81; ++i) {
            OperatorSubtaskState primaryAndFallback = this.generateForConfiguration(i);
            for (int j = 0; j < 9; ++j) {
                CreateAltSubtaskStateMode modeFirst = CreateAltSubtaskStateMode.byCode(j % 3);
                OperatorSubtaskState bestAlternative = modeFirst.createAlternativeSubtaskState(primaryAndFallback);
                CreateAltSubtaskStateMode modeSecond = CreateAltSubtaskStateMode.byCode(j / 3 % 3);
                OperatorSubtaskState secondBestAlternative = modeSecond.createAlternativeSubtaskState(primaryAndFallback);
                List<OperatorSubtaskState> orderedAlternativesList = Arrays.asList(bestAlternative, secondBestAlternative);
                ArrayList<OperatorSubtaskState> validAlternativesList = new ArrayList<OperatorSubtaskState>(3);
                if (modeFirst == CreateAltSubtaskStateMode.ONE_VALID_STATE_HANDLE) {
                    validAlternativesList.add(bestAlternative);
                }
                if (modeSecond == CreateAltSubtaskStateMode.ONE_VALID_STATE_HANDLE) {
                    validAlternativesList.add(secondBestAlternative);
                }
                validAlternativesList.add(primaryAndFallback);
                PrioritizedOperatorSubtaskState.Builder builder = new PrioritizedOperatorSubtaskState.Builder(primaryAndFallback, orderedAlternativesList);
                PrioritizedOperatorSubtaskState prioritizedOperatorSubtaskState = builder.build();
                OperatorSubtaskState[] validAlternatives = validAlternativesList.toArray(new OperatorSubtaskState[0]);
                OperatorSubtaskState[] onlyPrimary = new OperatorSubtaskState[]{primaryAndFallback};
                Assertions.assertThat((boolean)this.checkResultAsExpected(OperatorSubtaskState::getManagedOperatorState, PrioritizedOperatorSubtaskState::getPrioritizedManagedOperatorState, prioritizedOperatorSubtaskState, primaryAndFallback.getManagedOperatorState().size() == 1 ? validAlternatives : onlyPrimary)).isTrue();
                StateObjectCollection<KeyedStateHandle> expManagedKeyed = this.computeExpectedMixedState(orderedAlternativesList, primaryAndFallback, OperatorSubtaskState::getManagedKeyedState, KeyedStateHandle::getKeyGroupRange);
                PrioritizedOperatorSubtaskStateTest.assertResultAsExpected(expManagedKeyed, primaryAndFallback.getManagedKeyedState(), prioritizedOperatorSubtaskState.getPrioritizedManagedKeyedState());
                Assertions.assertThat((boolean)this.checkResultAsExpected(OperatorSubtaskState::getRawOperatorState, PrioritizedOperatorSubtaskState::getPrioritizedRawOperatorState, prioritizedOperatorSubtaskState, primaryAndFallback.getRawOperatorState().size() == 1 ? validAlternatives : onlyPrimary)).isTrue();
                StateObjectCollection<KeyedStateHandle> expRawKeyed = this.computeExpectedMixedState(orderedAlternativesList, primaryAndFallback, OperatorSubtaskState::getRawKeyedState, KeyedStateHandle::getKeyGroupRange);
                PrioritizedOperatorSubtaskStateTest.assertResultAsExpected(expRawKeyed, primaryAndFallback.getRawKeyedState(), prioritizedOperatorSubtaskState.getPrioritizedRawKeyedState());
            }
        }
    }

    private OperatorSubtaskState generateForConfiguration(int conf) {
        Preconditions.checkState((conf >= 0 && conf <= 80 ? 1 : 0) != 0);
        int numModes = 3;
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 4);
        KeyGroupRange keyGroupRange1 = new KeyGroupRange(0, 2);
        KeyGroupRange keyGroupRange2 = new KeyGroupRange(3, 4);
        int div = 1;
        int mode = conf / div % 3;
        StateObjectCollection s1 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewOperatorStateHandle(2, RANDOM))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewOperatorStateHandle(2, RANDOM), StateHandleDummyUtil.createNewOperatorStateHandle(2, RANDOM))));
        mode = conf / (div *= 3) % 3;
        StateObjectCollection s2 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewOperatorStateHandle(2, RANDOM))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewOperatorStateHandle(2, RANDOM), StateHandleDummyUtil.createNewOperatorStateHandle(2, RANDOM))));
        mode = conf / (div *= 3) % 3;
        StateObjectCollection s3 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange1), StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange2))));
        mode = conf / (div *= 3) % 3;
        StateObjectCollection s4 = mode == 0 ? StateObjectCollection.empty() : (mode == 1 ? new StateObjectCollection(Collections.singletonList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange))) : new StateObjectCollection(Arrays.asList(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange1), StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange2))));
        return OperatorSubtaskState.builder().setManagedOperatorState(s1).setRawOperatorState(s2).setManagedKeyedState(s3).setRawKeyedState(s4).build();
    }

    private <T extends StateObject> boolean checkResultAsExpected(Function<OperatorSubtaskState, StateObjectCollection<T>> extractor, Function<PrioritizedOperatorSubtaskState, List<StateObjectCollection<T>>> extractor2, PrioritizedOperatorSubtaskState prioritizedResult, OperatorSubtaskState ... expectedOrdered) {
        ArrayList<StateObjectCollection<T>> collector = new ArrayList<StateObjectCollection<T>>(expectedOrdered.length);
        for (OperatorSubtaskState operatorSubtaskState : expectedOrdered) {
            collector.add(extractor.apply(operatorSubtaskState));
        }
        return this.checkRepresentSameOrder(extractor2.apply(prioritizedResult).iterator(), collector.toArray(new StateObjectCollection[0]));
    }

    private boolean checkRepresentSameOrder(Iterator<? extends StateObjectCollection<?>> ordered, StateObjectCollection<?> ... expectedOrder) {
        for (StateObjectCollection<?> objects : expectedOrder) {
            if (ordered.hasNext() && this.checkContainedObjectsReferentialEquality(objects, ordered.next())) continue;
            return false;
        }
        return !ordered.hasNext();
    }

    public boolean checkContainedObjectsReferentialEquality(StateObjectCollection<?> a, StateObjectCollection<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator bIter = b.iterator();
        for (StateObject stateObject : a) {
            if (bIter.hasNext() && bIter.next() == stateObject) continue;
            return false;
        }
        return true;
    }

    private static <T extends StateObject> StateObjectCollection<T> deepCopyFirstElement(StateObjectCollection<T> original) {
        if (original.isEmpty()) {
            return StateObjectCollection.empty();
        }
        return StateObjectCollection.singleton((StateObject)PrioritizedOperatorSubtaskStateTest.deepCopy((StateObject)original.iterator().next()));
    }

    private static <T extends StateObject> StateObjectCollection<T> deepCopy(StateObjectCollection<T> original) {
        if (original == null || original.isEmpty()) {
            return StateObjectCollection.empty();
        }
        return new StateObjectCollection((Collection)original.stream().map(PrioritizedOperatorSubtaskStateTest::deepCopy).collect(Collectors.toList()));
    }

    private static <T extends StateObject> T deepCopy(T stateObject) {
        if (stateObject instanceof OperatorStreamStateHandle) {
            return (T)StateHandleDummyUtil.deepDummyCopy((OperatorStateHandle)stateObject);
        }
        if (stateObject instanceof KeyedStateHandle) {
            return (T)StateHandleDummyUtil.deepDummyCopy((KeyedStateHandle)stateObject);
        }
        if (stateObject instanceof InputChannelStateHandle) {
            return (T)StateHandleDummyUtil.deepDummyCopy((InputChannelStateHandle)stateObject);
        }
        if (stateObject instanceof ResultSubpartitionStateHandle) {
            return (T)StateHandleDummyUtil.deepDummyCopy((ResultSubpartitionStateHandle)stateObject);
        }
        throw new IllegalStateException();
    }

    private <T extends StateObject, ID> StateObjectCollection<T> computeExpectedMixedState(List<OperatorSubtaskState> orderedAlternativesList, OperatorSubtaskState primaryAndFallback, Function<OperatorSubtaskState, StateObjectCollection<T>> stateExtractor, Function<T, ID> idExtractor) {
        ArrayList<OperatorSubtaskState> reverseAlternatives = new ArrayList<OperatorSubtaskState>(orderedAlternativesList);
        Collections.reverse(reverseAlternatives);
        Map map = stateExtractor.apply(primaryAndFallback).stream().collect(Collectors.toMap(idExtractor, Function.identity()));
        reverseAlternatives.stream().flatMap(x -> ((StateObjectCollection)stateExtractor.apply((OperatorSubtaskState)x)).stream()).forEach(x -> map.replace(idExtractor.apply(x), x));
        return new StateObjectCollection(map.values());
    }

    static <SH extends StateObject> void assertResultAsExpected(StateObjectCollection<SH> expected, StateObjectCollection<SH> primary, List<StateObjectCollection<SH>> actual) {
        org.junit.jupiter.api.Assertions.assertTrue((!actual.isEmpty() && actual.size() <= 2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PrioritizedOperatorSubtaskStateTest.isSameContentUnordered(expected, (Collection)actual.get(0)));
        if (actual.size() == 1) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PrioritizedOperatorSubtaskStateTest.isSameContentUnordered(primary, (Collection)actual.get(0)));
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PrioritizedOperatorSubtaskStateTest.isSameContentUnordered(primary, (Collection)actual.get(1)));
        }
    }

    static <T> boolean isSameContentUnordered(Collection<T> a, Collection<T> b) {
        return a.size() == b.size() && a.containsAll(b);
    }

    private static enum CreateAltSubtaskStateMode {
        ONE_VALID_STATE_HANDLE(0){

            @Override
            public OperatorSubtaskState createAlternativeSubtaskState(OperatorSubtaskState primaryOriginal) {
                return OperatorSubtaskState.builder().setManagedOperatorState(PrioritizedOperatorSubtaskStateTest.deepCopyFirstElement(primaryOriginal.getManagedOperatorState())).setRawOperatorState(PrioritizedOperatorSubtaskStateTest.deepCopyFirstElement(primaryOriginal.getRawOperatorState())).setManagedKeyedState(PrioritizedOperatorSubtaskStateTest.deepCopyFirstElement(primaryOriginal.getManagedKeyedState())).setRawKeyedState(PrioritizedOperatorSubtaskStateTest.deepCopyFirstElement(primaryOriginal.getRawKeyedState())).setInputChannelState(PrioritizedOperatorSubtaskStateTest.deepCopy(primaryOriginal.getInputChannelState())).setResultSubpartitionState(PrioritizedOperatorSubtaskStateTest.deepCopy(primaryOriginal.getResultSubpartitionState())).build();
            }
        }
        ,
        EMPTY_STATE_HANDLE_COLLECTION(1){

            @Override
            public OperatorSubtaskState createAlternativeSubtaskState(OperatorSubtaskState primaryOriginal) {
                return OperatorSubtaskState.builder().build();
            }
        }
        ,
        ONE_INVALID_STATE_HANDLE(2){

            @Override
            public OperatorSubtaskState createAlternativeSubtaskState(OperatorSubtaskState primaryOriginal) {
                KeyGroupRange otherRange = new KeyGroupRange(8, 16);
                int numNamedStates = 2;
                return OperatorSubtaskState.builder().setManagedOperatorState(StateHandleDummyUtil.createNewOperatorStateHandle(numNamedStates, RANDOM)).setRawOperatorState(StateHandleDummyUtil.createNewOperatorStateHandle(numNamedStates, RANDOM)).setManagedKeyedState(StateHandleDummyUtil.createNewKeyedStateHandle(otherRange)).setRawKeyedState(StateHandleDummyUtil.createNewKeyedStateHandle(otherRange)).setInputChannelState(StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewInputChannelStateHandle(10, RANDOM))).setResultSubpartitionState(StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewResultSubpartitionStateHandle(10, RANDOM))).build();
            }
        };

        private final int code;

        private CreateAltSubtaskStateMode(int code) {
            this.code = code;
        }

        static CreateAltSubtaskStateMode byCode(int code) {
            for (CreateAltSubtaskStateMode v : CreateAltSubtaskStateMode.values()) {
                if (v.code != code) continue;
                return v;
            }
            throw new IllegalArgumentException("unknown code: " + code);
        }

        public abstract OperatorSubtaskState createAlternativeSubtaskState(OperatorSubtaskState var1);
    }
}

