/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.FullyFinishedOperatorState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FullyFinishedOperatorStateTest {
    FullyFinishedOperatorStateTest() {
    }

    @Test
    void testFullyFinishedOperatorState() {
        FullyFinishedOperatorState operatorState = new FullyFinishedOperatorState(new OperatorID(), 5, 256);
        Assertions.assertThat((boolean)operatorState.isFullyFinished()).isTrue();
        Assertions.assertThat((Map)operatorState.getSubtaskStates()).isEmpty();
        Assertions.assertThat((Collection)operatorState.getStates()).isEmpty();
        Assertions.assertThat((int)operatorState.getNumberCollectedStates()).isZero();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FullyFinishedOperatorStateTest.lambda$testFullyFinishedOperatorState$0((OperatorState)operatorState)).as("Should not be able to put new subtask states for a fully finished state", new Object[0])).isInstanceOf(UnsupportedOperationException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FullyFinishedOperatorStateTest.lambda$testFullyFinishedOperatorState$1((OperatorState)operatorState)).as("Should not be able to put new subtask states for a fully finished state", new Object[0])).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testGetDiscardables() throws IOException {
        Tuple2<List<StateObject>, OperatorSubtaskState> opSubtaskStates1 = CheckpointCoordinatorTestingUtils.generateSampleOperatorSubtaskState();
        Tuple2<List<StateObject>, OperatorSubtaskState> opSubtaskStates2 = CheckpointCoordinatorTestingUtils.generateSampleOperatorSubtaskState();
        OperatorState operatorState = new OperatorState(new OperatorID(), 2, 256);
        operatorState.putState(0, (OperatorSubtaskState)opSubtaskStates1.f1);
        operatorState.putState(1, (OperatorSubtaskState)opSubtaskStates2.f1);
        ByteStreamStateHandle coordinatorState = new ByteStreamStateHandle("test", new byte[]{1, 2, 3, 4});
        operatorState.setCoordinatorState(coordinatorState);
        HashSet discardables = new HashSet();
        discardables.addAll(((List)opSubtaskStates1.f0).subList(0, 4));
        discardables.add(((InputChannelStateHandle)((List)opSubtaskStates1.f0).get(4)).getDelegate());
        discardables.add(((ResultSubpartitionStateHandle)((List)opSubtaskStates1.f0).get(5)).getDelegate());
        discardables.addAll(((List)opSubtaskStates2.f0).subList(0, 4));
        discardables.add(((InputChannelStateHandle)((List)opSubtaskStates2.f0).get(4)).getDelegate());
        discardables.add(((ResultSubpartitionStateHandle)((List)opSubtaskStates2.f0).get(5)).getDelegate());
        discardables.add(coordinatorState);
        Assertions.assertThat(new HashSet(operatorState.getDiscardables())).isEqualTo(discardables);
    }

    private static /* synthetic */ void lambda$testFullyFinishedOperatorState$1(OperatorState operatorState) throws Throwable {
        operatorState.setCoordinatorState(new ByteStreamStateHandle("test", new byte[]{1, 2, 3, 4}));
    }

    private static /* synthetic */ void lambda$testFullyFinishedOperatorState$0(OperatorState operatorState) throws Throwable {
        operatorState.putState(0, OperatorSubtaskState.builder().build());
    }
}

