/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointStatsCountsTest {
    CheckpointStatsCountsTest() {
    }

    @Test
    void testCounts() {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        Assertions.assertThat((long)counts.getNumberOfRestoredCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getTotalNumberOfCheckpoints()).isZero();
        Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfCompletedCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfFailedCheckpoints()).isZero();
        counts.incrementRestoredCheckpoints();
        Assertions.assertThat((long)counts.getNumberOfRestoredCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getTotalNumberOfCheckpoints()).isZero();
        Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfCompletedCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfFailedCheckpoints()).isZero();
        counts.incrementInProgressCheckpoints();
        Assertions.assertThat((long)counts.getNumberOfRestoredCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getTotalNumberOfCheckpoints()).isOne();
        Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getNumberOfCompletedCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfFailedCheckpoints()).isZero();
        counts.incrementCompletedCheckpoints();
        Assertions.assertThat((long)counts.getNumberOfRestoredCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getTotalNumberOfCheckpoints()).isOne();
        Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfCompletedCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getNumberOfFailedCheckpoints()).isZero();
        counts.incrementInProgressCheckpoints();
        Assertions.assertThat((long)counts.getNumberOfRestoredCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getTotalNumberOfCheckpoints()).isEqualTo(2L);
        Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getNumberOfCompletedCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getNumberOfFailedCheckpoints()).isZero();
        counts.incrementFailedCheckpoints();
        Assertions.assertThat((long)counts.getNumberOfRestoredCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getTotalNumberOfCheckpoints()).isEqualTo(2L);
        Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfCompletedCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getNumberOfFailedCheckpoints()).isOne();
        counts.incrementFailedCheckpointsWithoutInProgress();
        Assertions.assertThat((long)counts.getNumberOfRestoredCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getTotalNumberOfCheckpoints()).isEqualTo(3L);
        Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).isZero();
        Assertions.assertThat((long)counts.getNumberOfCompletedCheckpoints()).isOne();
        Assertions.assertThat((long)counts.getNumberOfFailedCheckpoints()).isEqualTo(2L);
    }

    @Test
    void testCompleteOrFailWithoutInProgressCheckpoint() {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        counts.incrementCompletedCheckpoints();
        ((AbstractIntegerAssert)Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).as("Number of checkpoints in progress should never be negative", new Object[0])).isGreaterThanOrEqualTo(0);
        counts.incrementFailedCheckpoints();
        ((AbstractIntegerAssert)Assertions.assertThat((int)counts.getNumberOfInProgressCheckpoints()).as("Number of checkpoints in progress should never be negative", new Object[0])).isGreaterThanOrEqualTo(0);
    }

    @Test
    void testCreateSnapshot() {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        counts.incrementRestoredCheckpoints();
        counts.incrementRestoredCheckpoints();
        counts.incrementRestoredCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementFailedCheckpoints();
        long restored = counts.getNumberOfRestoredCheckpoints();
        long total = counts.getTotalNumberOfCheckpoints();
        long inProgress = counts.getNumberOfInProgressCheckpoints();
        long completed = counts.getNumberOfCompletedCheckpoints();
        long failed = counts.getNumberOfFailedCheckpoints();
        CheckpointStatsCounts snapshot = counts.createSnapshot();
        Assertions.assertThat((long)snapshot.getNumberOfRestoredCheckpoints()).isEqualTo(restored);
        Assertions.assertThat((long)snapshot.getTotalNumberOfCheckpoints()).isEqualTo(total);
        Assertions.assertThat((int)snapshot.getNumberOfInProgressCheckpoints()).isEqualTo(inProgress);
        Assertions.assertThat((long)snapshot.getNumberOfCompletedCheckpoints()).isEqualTo(completed);
        Assertions.assertThat((long)snapshot.getNumberOfFailedCheckpoints()).isEqualTo(failed);
        counts.incrementRestoredCheckpoints();
        counts.incrementRestoredCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementFailedCheckpoints();
        Assertions.assertThat((long)snapshot.getNumberOfRestoredCheckpoints()).isEqualTo(restored);
        Assertions.assertThat((long)snapshot.getTotalNumberOfCheckpoints()).isEqualTo(total);
        Assertions.assertThat((int)snapshot.getNumberOfInProgressCheckpoints()).isEqualTo(inProgress);
        Assertions.assertThat((long)snapshot.getNumberOfCompletedCheckpoints()).isEqualTo(completed);
        Assertions.assertThat((long)snapshot.getNumberOfFailedCheckpoints()).isEqualTo(failed);
    }
}

