/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BlobServerSslTest {
    BlobServerSslTest() {
    }

    @Test
    void testFailedToInitWithTwoProtocolsSet() {
        Configuration config = new Configuration();
        config.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)true);
        config.set(SecurityOptions.SSL_KEYSTORE, (Object)this.getClass().getResource("/local127.keystore").getPath());
        config.set(SecurityOptions.SSL_KEYSTORE_PASSWORD, (Object)"password");
        config.set(SecurityOptions.SSL_KEY_PASSWORD, (Object)"password");
        config.set(SecurityOptions.SSL_TRUSTSTORE, (Object)this.getClass().getResource("/local127.truststore").getPath());
        config.set(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, (Object)"password");
        config.set(SecurityOptions.SSL_ALGORITHMS, (Object)"TLSv1,TLSv1.1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BlobServer(config, new File("foobar"), (BlobStore)new VoidBlobStore())).isInstanceOf(IOException.class)).hasMessage("Unable to open BLOB Server in specified port range: 0");
    }

    @Test
    void testFailedToInitWithInvalidSslKeystoreConfigured() {
        Configuration config = new Configuration();
        config.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)true);
        config.set(SecurityOptions.SSL_KEYSTORE, (Object)"invalid.keystore");
        config.set(SecurityOptions.SSL_KEYSTORE_PASSWORD, (Object)"password");
        config.set(SecurityOptions.SSL_KEY_PASSWORD, (Object)"password");
        config.set(SecurityOptions.SSL_TRUSTSTORE, (Object)"invalid.keystore");
        config.set(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, (Object)"password");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BlobServer(config, new File("foobar"), (BlobStore)new VoidBlobStore())).isInstanceOf(IOException.class)).hasMessage("Failed to initialize SSL for the blob server");
    }

    @Test
    void testFailedToInitWithMissingMandatorySslConfiguration() {
        Configuration config = new Configuration();
        config.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BlobServer(config, new File("foobar"), (BlobStore)new VoidBlobStore())).isInstanceOf(IOException.class)).hasMessage("Failed to initialize SSL for the blob server");
    }
}

