/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.BlobCacheSizeTracker;
import org.apache.flink.runtime.blob.BlobKey;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BlobCacheSizeTrackerTest {
    private BlobCacheSizeTracker tracker;
    private JobID jobId;
    private BlobKey blobKey;

    BlobCacheSizeTrackerTest() {
    }

    @BeforeEach
    void setup() {
        this.tracker = new BlobCacheSizeTracker(5L);
        this.jobId = new JobID();
        this.blobKey = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB);
        this.tracker.track(this.jobId, this.blobKey, 3L);
    }

    @Test
    void testCheckLimit() {
        List keys = this.tracker.checkLimit(3L);
        Assertions.assertThat((List)keys).hasSize(1);
        Assertions.assertThat((Comparable)((Comparable)((Tuple2)keys.get((int)0)).f0)).isEqualTo((Object)this.jobId);
        Assertions.assertThat((Comparable)((Comparable)((Tuple2)keys.get((int)0)).f1)).isEqualTo((Object)this.blobKey);
    }

    @Test
    void testCheckLimitForEmptyBlob() {
        List keys = this.tracker.checkLimit(0L);
        Assertions.assertThat((List)keys).isEmpty();
    }

    @Test
    void testCheckLimitForBlobWithNegativeSize() {
        Assertions.assertThatThrownBy(() -> this.tracker.checkLimit(-1L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testTrack() {
        Assertions.assertThat((Long)this.tracker.getSize(this.jobId, this.blobKey)).isEqualTo(3L);
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).contains((Object[])new BlobKey[]{this.blobKey});
    }

    @Test
    void testTrackDuplicatedBlob() {
        this.tracker.track(this.jobId, this.blobKey, 1L);
        Assertions.assertThat((Long)this.tracker.getSize(this.jobId, this.blobKey)).isEqualTo(3L);
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).hasSize(1);
    }

    @Test
    void testUntrack() {
        Assertions.assertThat((List)this.tracker.checkLimit(3L)).hasSize(1);
        this.tracker.untrack(Tuple2.of((Object)this.jobId, (Object)this.blobKey));
        Assertions.assertThat((Long)this.tracker.getSize(this.jobId, this.blobKey)).isNull();
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).isEmpty();
        Assertions.assertThat((List)this.tracker.checkLimit(3L)).isEmpty();
    }

    @Test
    void testUntrackNonExistingBlob() {
        this.tracker.untrack(Tuple2.of((Object)this.jobId, (Object)BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB)));
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).hasSize(1);
    }

    @Test
    void testUntrackBlobWithNullJobId() {
        Assertions.assertThatThrownBy(() -> this.tracker.untrack(Tuple2.of(null, (Object)BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB)))).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testUpdate() {
        int i;
        BlobCacheSizeTracker tracker = new BlobCacheSizeTracker(5L);
        ArrayList<JobID> jobIds = new ArrayList<JobID>();
        ArrayList<BlobKey> blobKeys = new ArrayList<BlobKey>();
        for (i = 0; i < 5; ++i) {
            jobIds.add(new JobID());
            blobKeys.add(BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB));
        }
        for (i = 0; i < 5; ++i) {
            tracker.track((JobID)jobIds.get(i), (BlobKey)blobKeys.get(i), 1L);
        }
        tracker.update((JobID)jobIds.get(1), (BlobKey)blobKeys.get(1));
        tracker.update((JobID)jobIds.get(2), (BlobKey)blobKeys.get(2));
        List blobsToDelete = tracker.checkLimit(2L);
        Assertions.assertThat((List)blobsToDelete).contains((Object[])new Tuple2[]{Tuple2.of(jobIds.get(0), blobKeys.get(0)), Tuple2.of(jobIds.get(3), blobKeys.get(3))});
    }

    @Test
    void testUpdateNonExistingBlob() {
        this.tracker.track(new JobID(), BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 2L);
        Assertions.assertThat((List)this.tracker.checkLimit(3L)).hasSize(1);
        this.tracker.update(new JobID(), BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB));
        Assertions.assertThat((List)this.tracker.checkLimit(3L)).hasSize(1);
    }

    @Test
    void testUntrackAll() {
        this.tracker.track(this.jobId, BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 1L);
        JobID anotherJobId = new JobID();
        this.tracker.track(anotherJobId, BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 1L);
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).hasSize(2);
        this.tracker.untrackAll(this.jobId);
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).isEmpty();
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(anotherJobId)).hasSize(1);
    }

    @Test
    void testUntrackAllWithNonExistingJob() {
        this.tracker.track(this.jobId, BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 1L);
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).hasSize(2);
        this.tracker.untrackAll(new JobID());
        Assertions.assertThat((Collection)this.tracker.getBlobKeysByJobId(this.jobId)).hasSize(2);
    }
}

