/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Arrays;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class EnvironmentInformationTest
extends TestLogger {
    @Test
    public void testJavaMemory() {
        try {
            long fullHeap = EnvironmentInformation.getMaxJvmHeapMemory();
            long freeWithGC = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            Assert.assertTrue((fullHeap > 0L ? 1 : 0) != 0);
            Assert.assertTrue((freeWithGC >= 0L ? 1 : 0) != 0);
            try {
                long free = EnvironmentInformation.getSizeOfFreeHeapMemory();
                Assert.assertTrue((free >= 0L ? 1 : 0) != 0);
            }
            catch (RuntimeException e) {
                Assert.assertEquals((long)Long.MAX_VALUE, (long)EnvironmentInformation.getMaxJvmHeapMemory());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEnvironmentMethods() {
        try {
            Assert.assertNotNull((Object)EnvironmentInformation.getJvmStartupOptions());
            Assert.assertNotNull((Object)EnvironmentInformation.getJvmStartupOptionsArray());
            Assert.assertNotNull((Object)EnvironmentInformation.getJvmVersion());
            Assert.assertNotNull((Object)EnvironmentInformation.getRevisionInformation());
            Assert.assertNotNull((Object)EnvironmentInformation.getVersion());
            Assert.assertNotNull((Object)EnvironmentInformation.getScalaVersion());
            Assert.assertNotNull((Object)EnvironmentInformation.getBuildTime());
            Assert.assertNotNull((Object)EnvironmentInformation.getBuildTimeString());
            Assert.assertNotNull((Object)EnvironmentInformation.getGitCommitId());
            Assert.assertNotNull((Object)EnvironmentInformation.getGitCommitIdAbbrev());
            Assert.assertNotNull((Object)EnvironmentInformation.getGitCommitTime());
            Assert.assertNotNull((Object)EnvironmentInformation.getGitCommitTimeString());
            EnvironmentInformation.getHadoopVersionString();
            Assert.assertNotNull((Object)EnvironmentInformation.getHadoopUser());
            Assert.assertTrue((EnvironmentInformation.getOpenFileHandlesLimit() >= -1L ? 1 : 0) != 0);
            if (this.log.isInfoEnabled()) {
                this.log.info("JvmStartupOptions      : {}", (Object)EnvironmentInformation.getJvmStartupOptions());
                this.log.info("JvmStartupOptionsArray : {}", Arrays.asList(EnvironmentInformation.getJvmStartupOptionsArray()));
                this.log.info("JvmVersion             : {}", (Object)EnvironmentInformation.getJvmVersion());
                this.log.info("RevisionInformation    : {}", (Object)EnvironmentInformation.getRevisionInformation());
                this.log.info("Version                : {}", (Object)EnvironmentInformation.getVersion());
                this.log.info("ScalaVersion           : {}", (Object)EnvironmentInformation.getScalaVersion());
                this.log.info("BuildTime              : {}", (Object)EnvironmentInformation.getBuildTime());
                this.log.info("BuildTimeString        : {}", (Object)EnvironmentInformation.getBuildTimeString());
                this.log.info("GitCommitId            : {}", (Object)EnvironmentInformation.getGitCommitId());
                this.log.info("GitCommitIdAbbrev      : {}", (Object)EnvironmentInformation.getGitCommitIdAbbrev());
                this.log.info("GitCommitTime          : {}", (Object)EnvironmentInformation.getGitCommitTime());
                this.log.info("GitCommitTimeString    : {}", (Object)EnvironmentInformation.getGitCommitTimeString());
                this.log.info("HadoopVersionString    : {}", (Object)EnvironmentInformation.getHadoopVersionString());
                this.log.info("HadoopUser             : {}", (Object)EnvironmentInformation.getHadoopUser());
                this.log.info("OpenFileHandlesLimit   : {}", (Object)EnvironmentInformation.getOpenFileHandlesLimit());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLogEnvironmentInformation() {
        try {
            Logger mockLogger = (Logger)Mockito.mock(Logger.class);
            EnvironmentInformation.logEnvironmentInfo((Logger)mockLogger, (String)"test", (String[])new String[0]);
            EnvironmentInformation.logEnvironmentInfo((Logger)mockLogger, (String)"test", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

