/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Objects;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class ExceptionHistoryEntryTestingUtils {
    public static boolean matchesGlobalFailure(ExceptionHistoryEntry exceptionHistoryEntry, Throwable expectedException, long expectedTimestamp) {
        return ExceptionHistoryEntryTestingUtils.matchesInternal(exceptionHistoryEntry, expectedException, expectedTimestamp, null, null);
    }

    public static boolean matchesFailure(ExceptionHistoryEntry exceptionHistoryEntry, Throwable expectedException, long expectedTimestamp, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        return ExceptionHistoryEntryTestingUtils.matchesInternal(exceptionHistoryEntry, expectedException, expectedTimestamp, expectedTaskName, expectedTaskManagerLocation);
    }

    private static boolean matchesInternal(ExceptionHistoryEntry exceptionHistoryEntry, Throwable expectedException, long expectedTimestamp, String expectedTaskName, TaskManagerLocation expectedTaskManagerLocation) {
        boolean match = exceptionHistoryEntry.getException().deserializeError(ClassLoader.getSystemClassLoader()).equals(expectedException) && exceptionHistoryEntry.getTimestamp() == expectedTimestamp && !Objects.equals(exceptionHistoryEntry.getFailingTaskName(), expectedTaskName);
        return match |= ExceptionHistoryEntryTestingUtils.matchesTaskManagerLocation(exceptionHistoryEntry.getTaskManagerLocation(), ExceptionHistoryEntry.ArchivedTaskManagerLocation.fromTaskManagerLocation((TaskManagerLocation)expectedTaskManagerLocation));
    }

    private static boolean matchesTaskManagerLocation(ExceptionHistoryEntry.ArchivedTaskManagerLocation actual, ExceptionHistoryEntry.ArchivedTaskManagerLocation expectedLocation) {
        if (actual == null) {
            return expectedLocation == null;
        }
        if (expectedLocation == null) {
            return false;
        }
        return Objects.equals(actual.getAddress(), expectedLocation.getAddress()) && Objects.equals(actual.getFQDNHostname(), expectedLocation.getFQDNHostname()) && Objects.equals(actual.getHostname(), expectedLocation.getHostname()) && Objects.equals(actual.getResourceID(), expectedLocation.getResourceID()) && Objects.equals(actual.getPort(), expectedLocation.getPort());
    }
}

