/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Optional;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.scheduler.AvailableInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.TestingInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AvailableInputsLocationsRetrieverTest {
    private static final ExecutionVertexID EV1 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV2 = ExecutionGraphTestUtils.createRandomExecutionVertexId();

    AvailableInputsLocationsRetrieverTest() {
    }

    @Test
    void testNoInputLocation() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assertions.assertThat((Optional)availableInputsLocationsRetriever.getTaskManagerLocation(EV1)).isNotPresent();
    }

    @Test
    void testNoInputLocationIfNotDone() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        originalLocationRetriever.markScheduled(EV1);
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assertions.assertThat((Optional)availableInputsLocationsRetriever.getTaskManagerLocation(EV1)).isNotPresent();
    }

    @Test
    void testNoInputLocationIfFailed() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        originalLocationRetriever.failTaskManagerLocation(EV1, new Throwable());
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assertions.assertThat((Optional)availableInputsLocationsRetriever.getTaskManagerLocation(EV1)).isNotPresent();
    }

    @Test
    void testInputLocationIfDone() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        originalLocationRetriever.assignTaskManagerLocation(EV1);
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assertions.assertThat((Optional)availableInputsLocationsRetriever.getTaskManagerLocation(EV1)).isPresent();
    }

    @Test
    void testGetConsumedPartitionGroupAndProducers() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        ConsumedPartitionGroup consumedPartitionGroup = (ConsumedPartitionGroup)Iterables.getOnlyElement((Iterable)availableInputsLocationsRetriever.getConsumedPartitionGroups(EV2));
        Assertions.assertThat((Iterable)consumedPartitionGroup).hasSize(1);
        Collection producers = availableInputsLocationsRetriever.getProducersOfConsumedPartitionGroup(consumedPartitionGroup);
        Assertions.assertThat((Collection)producers).containsExactly((Object[])new ExecutionVertexID[]{EV1});
    }

    private static TestingInputsLocationsRetriever getOriginalLocationRetriever() {
        return new TestingInputsLocationsRetriever.Builder().connectConsumerToProducer(EV2, EV1).build();
    }
}

