/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.RuntimeMessageHeaders;
import org.apache.flink.runtime.rest.util.TestRestServerEndpoint;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUploadResource
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartUploadResource.class);
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private RestServerEndpoint serverEndpoint;
    protected String serverAddress;
    protected InetSocketAddress serverSocketAddress;
    protected MultipartMixedHandler mixedHandler;
    protected MultipartJsonHandler jsonHandler;
    protected MultipartFileHandler fileHandler;
    protected File file1;
    protected File file2;
    private Path configuredUploadDir;
    private BiConsumerWithException<HandlerRequest<?>, RestfulGateway, RestHandlerException> fileUploadVerifier;

    public void before() throws Exception {
        this.temporaryFolder.create();
        Configuration config = new Configuration();
        config.setString(RestOptions.BIND_PORT, "0");
        config.setString(RestOptions.ADDRESS, "localhost");
        config.setInteger(RestOptions.SERVER_MAX_CONTENT_LENGTH, 0x100000);
        this.configuredUploadDir = this.temporaryFolder.newFolder().toPath();
        config.setString(WebOptions.UPLOAD_DIR, this.configuredUploadDir.toString());
        RestfulGateway mockRestfulGateway = (RestfulGateway)Mockito.mock(RestfulGateway.class);
        GatewayRetriever mockGatewayRetriever = () -> CompletableFuture.completedFuture(mockRestfulGateway);
        this.file1 = this.temporaryFolder.newFile();
        try (RandomAccessFile rw = new RandomAccessFile(this.file1, "rw");){
            rw.setLength(0x4CF4F4L);
        }
        this.file2 = this.temporaryFolder.newFile();
        Files.write(this.file2.toPath(), "world".getBytes(ConfigConstants.DEFAULT_CHARSET), new OpenOption[0]);
        this.mixedHandler = new MultipartMixedHandler((GatewayRetriever<RestfulGateway>)mockGatewayRetriever);
        this.jsonHandler = new MultipartJsonHandler((GatewayRetriever<RestfulGateway>)mockGatewayRetriever);
        this.fileHandler = new MultipartFileHandler((GatewayRetriever<RestfulGateway>)mockGatewayRetriever);
        this.serverEndpoint = TestRestServerEndpoint.builder(config).withHandler(this.mixedHandler).withHandler(this.jsonHandler).withHandler(this.fileHandler).buildAndStart();
        this.serverAddress = this.serverEndpoint.getRestBaseUrl();
        this.serverSocketAddress = this.serverEndpoint.getServerAddress();
        this.setFileUploadVerifier((BiConsumerWithException<HandlerRequest<? extends RequestBody>, RestfulGateway, Exception>)((BiConsumerWithException)(request, restfulGateway) -> MultipartUploadResource.assertUploadedFilesEqual(request, this.getFilesToUpload())));
    }

    public static void assertUploadedFilesEqual(HandlerRequest<?> request, Collection<File> files) throws IOException {
        List expectedFiles = files.stream().map(File::toPath).collect(Collectors.toList());
        List uploadedFiles = request.getUploadedFiles().stream().map(File::toPath).collect(Collectors.toList());
        Assert.assertEquals((long)expectedFiles.size(), (long)uploadedFiles.size());
        ArrayList expectedList = new ArrayList(expectedFiles);
        ArrayList actualList = new ArrayList(uploadedFiles);
        expectedList.sort(Comparator.comparing(Path::toString));
        actualList.sort(Comparator.comparing(Path::toString));
        for (int x = 0; x < expectedList.size(); ++x) {
            Path expected = (Path)expectedList.get(x);
            Path actual = (Path)actualList.get(x);
            Assert.assertEquals((Object)expected.getFileName().toString(), (Object)actual.getFileName().toString());
            byte[] originalContent = Files.readAllBytes(expected);
            byte[] receivedContent = Files.readAllBytes(actual);
            Assert.assertArrayEquals((byte[])originalContent, (byte[])receivedContent);
        }
    }

    public void setFileUploadVerifier(BiConsumerWithException<HandlerRequest<? extends RequestBody>, RestfulGateway, Exception> verifier) {
        this.fileUploadVerifier = (request, restfulGateway) -> {
            try {
                verifier.accept(request, restfulGateway);
            }
            catch (Exception e) {
                throw new RestHandlerException("Test verification failed.", HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED, (Throwable)e);
            }
        };
    }

    public Collection<File> getFilesToUpload() {
        return Arrays.asList(this.file1, this.file2);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public InetSocketAddress getServerSocketAddress() {
        return this.serverSocketAddress;
    }

    public MultipartMixedHandler getMixedHandler() {
        return this.mixedHandler;
    }

    public MultipartFileHandler getFileHandler() {
        return this.fileHandler;
    }

    public MultipartJsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public Path getUploadDirectory() {
        return this.configuredUploadDir;
    }

    public void resetState() {
        this.mixedHandler.lastReceivedRequest = null;
        this.jsonHandler.lastReceivedRequest = null;
    }

    public void after() {
        this.temporaryFolder.delete();
        if (this.serverEndpoint != null) {
            try {
                this.serverEndpoint.close();
            }
            catch (Exception e) {
                LOG.warn("Could not properly shutdown RestServerEndpoint.", (Throwable)e);
            }
            this.serverEndpoint = null;
        }
    }

    public void assertUploadDirectoryIsEmpty() throws IOException {
        Path actualUploadDir;
        try (Stream<Path> containedFiles = Files.list(this.configuredUploadDir);){
            List files = containedFiles.collect(Collectors.toList());
            Preconditions.checkArgument((1 == files.size() ? 1 : 0) != 0, (Object)"Directory structure in rest upload directory has changed. Test must be adjusted");
            actualUploadDir = (Path)files.get(0);
        }
        containedFiles = Files.list(actualUploadDir);
        var3_2 = null;
        try {
            Assert.assertEquals((String)"Not all files were cleaned up.", (long)0L, (long)containedFiles.count());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (containedFiles != null) {
                if (var3_2 != null) {
                    try {
                        containedFiles.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    containedFiles.close();
                }
            }
        }
    }

    protected static final class TestRequestBody
    implements RequestBody {
        private static final String FIELD_NAME_INDEX = "index";
        @JsonProperty(value="index")
        private final int index;

        TestRequestBody() {
            this(-766974635);
        }

        @JsonCreator
        TestRequestBody(@JsonProperty(value="index") int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestRequestBody that = (TestRequestBody)o;
            return this.index == that.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        public String toString() {
            return "TestRequestBody{index=" + this.index + '}';
        }
    }

    private static abstract class TestHeadersBase<R extends RequestBody>
    implements RuntimeMessageHeaders<R, EmptyResponseBody, EmptyMessageParameters> {
        private TestHeadersBase() {
        }

        public Class<EmptyResponseBody> getResponseClass() {
            return EmptyResponseBody.class;
        }

        public HttpResponseStatus getResponseStatusCode() {
            return HttpResponseStatus.OK;
        }

        public String getDescription() {
            return "";
        }

        public EmptyMessageParameters getUnresolvedMessageParameters() {
            return EmptyMessageParameters.getInstance();
        }

        public HttpMethodWrapper getHttpMethod() {
            return HttpMethodWrapper.POST;
        }
    }

    private static class MultipartFileHeaders
    extends TestHeadersBase<EmptyRequestBody> {
        static final MultipartFileHeaders INSTANCE = new MultipartFileHeaders();

        private MultipartFileHeaders() {
        }

        public Class<EmptyRequestBody> getRequestClass() {
            return EmptyRequestBody.class;
        }

        public String getTargetRestEndpointURL() {
            return "/test/upload/file";
        }

        public boolean acceptsFileUploads() {
            return true;
        }
    }

    public class MultipartFileHandler
    extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters> {
        MultipartFileHandler(GatewayRetriever<RestfulGateway> leaderRetriever) {
            super(leaderRetriever, RpcUtils.INF_TIMEOUT, Collections.emptyMap(), (MessageHeaders)MultipartFileHeaders.INSTANCE);
        }

        protected CompletableFuture<EmptyResponseBody> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
            MultipartUploadResource.this.fileUploadVerifier.accept(request, (Object)gateway);
            return CompletableFuture.completedFuture(EmptyResponseBody.getInstance());
        }
    }

    public static class MultipartJsonHandler
    extends AbstractRestHandler<RestfulGateway, TestRequestBody, EmptyResponseBody, EmptyMessageParameters> {
        volatile TestRequestBody lastReceivedRequest = null;

        MultipartJsonHandler(GatewayRetriever<RestfulGateway> leaderRetriever) {
            super(leaderRetriever, RpcUtils.INF_TIMEOUT, Collections.emptyMap(), (MessageHeaders)MultipartJsonHeaders.INSTANCE);
        }

        protected CompletableFuture<EmptyResponseBody> handleRequest(@Nonnull HandlerRequest<TestRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
            Collection uploadedFiles = request.getUploadedFiles().stream().map(File::toPath).collect(Collectors.toList());
            if (!uploadedFiles.isEmpty()) {
                throw new RestHandlerException("This handler should not have received file uploads.", HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            this.lastReceivedRequest = (TestRequestBody)request.getRequestBody();
            return CompletableFuture.completedFuture(EmptyResponseBody.getInstance());
        }

        private static final class MultipartJsonHeaders
        extends TestHeadersBase<TestRequestBody> {
            private static final MultipartJsonHeaders INSTANCE = new MultipartJsonHeaders();

            private MultipartJsonHeaders() {
            }

            public Class<TestRequestBody> getRequestClass() {
                return TestRequestBody.class;
            }

            public String getTargetRestEndpointURL() {
                return "/test/upload/json";
            }

            public boolean acceptsFileUploads() {
                return false;
            }
        }
    }

    private static final class MultipartMixedHeaders
    implements RuntimeMessageHeaders<TestRequestBody, EmptyResponseBody, EmptyMessageParameters> {
        private static final MultipartMixedHeaders INSTANCE = new MultipartMixedHeaders();

        private MultipartMixedHeaders() {
        }

        public Class<TestRequestBody> getRequestClass() {
            return TestRequestBody.class;
        }

        public Class<EmptyResponseBody> getResponseClass() {
            return EmptyResponseBody.class;
        }

        public HttpResponseStatus getResponseStatusCode() {
            return HttpResponseStatus.OK;
        }

        public String getDescription() {
            return "";
        }

        public EmptyMessageParameters getUnresolvedMessageParameters() {
            return EmptyMessageParameters.getInstance();
        }

        public HttpMethodWrapper getHttpMethod() {
            return HttpMethodWrapper.POST;
        }

        public String getTargetRestEndpointURL() {
            return "/test/upload/mixed";
        }

        public boolean acceptsFileUploads() {
            return true;
        }
    }

    public class MultipartMixedHandler
    extends AbstractRestHandler<RestfulGateway, TestRequestBody, EmptyResponseBody, EmptyMessageParameters> {
        volatile TestRequestBody lastReceivedRequest;

        MultipartMixedHandler(GatewayRetriever<RestfulGateway> leaderRetriever) {
            super(leaderRetriever, RpcUtils.INF_TIMEOUT, Collections.emptyMap(), (MessageHeaders)MultipartMixedHeaders.INSTANCE);
            this.lastReceivedRequest = null;
        }

        protected CompletableFuture<EmptyResponseBody> handleRequest(@Nonnull HandlerRequest<TestRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
            MultipartUploadResource.this.fileUploadVerifier.accept(request, (Object)gateway);
            this.lastReceivedRequest = (TestRequestBody)request.getRequestBody();
            return CompletableFuture.completedFuture(EmptyResponseBody.getInstance());
        }
    }
}

