/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfileTestingUtils;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.junit.rules.ExternalResource;

public class PhysicalSlotProviderResource
extends ExternalResource {
    private ScheduledExecutorService singleThreadScheduledExecutorService;
    private ComponentMainThreadExecutor mainThreadExecutor;
    private final SlotSelectionStrategy slotSelectionStrategy;
    private DeclarativeSlotPoolBridge slotPool;
    private PhysicalSlotProvider physicalSlotProvider;

    public PhysicalSlotProviderResource(@Nonnull SlotSelectionStrategy slotSelectionStrategy) {
        this.slotSelectionStrategy = slotSelectionStrategy;
    }

    protected void before() throws Throwable {
        this.singleThreadScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.mainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forSingleThreadExecutor(this.singleThreadScheduledExecutorService);
        this.slotPool = new DeclarativeSlotPoolBridgeBuilder().buildAndStart(this.mainThreadExecutor);
        this.physicalSlotProvider = new PhysicalSlotProviderImpl(this.slotSelectionStrategy, (SlotPool)this.slotPool);
    }

    protected void after() {
        CompletableFuture.runAsync(() -> this.slotPool.close(), (Executor)this.mainThreadExecutor).join();
        this.singleThreadScheduledExecutorService.shutdown();
    }

    public CompletableFuture<PhysicalSlotRequest.Result> allocateSlot(PhysicalSlotRequest request) {
        return CompletableFuture.supplyAsync(() -> this.physicalSlotProvider.allocatePhysicalSlot(request), (Executor)this.mainThreadExecutor).thenCompose(Function.identity());
    }

    public void registerSlotOffersFromNewTaskExecutor(ResourceProfile ... resourceProfiles) {
        CompletableFuture.runAsync(() -> this.slotPool.increaseResourceRequirementsBy(SlotPoolUtils.calculateResourceCounter(resourceProfiles)), (Executor)this.mainThreadExecutor).join();
        SlotPoolUtils.offerSlots((SlotPool)this.slotPool, this.mainThreadExecutor, Arrays.asList(resourceProfiles));
    }

    public PhysicalSlotRequest createSimpleRequest() {
        return new PhysicalSlotRequest(new SlotRequestId(), SlotProfileTestingUtils.noLocality(ResourceProfile.UNKNOWN), false);
    }

    public ComponentMainThreadExecutor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }
}

