/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.net.URLClassLoader;
import org.apache.flink.runtime.rpc.messages.RemoteRpcInvocation;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class ClassLoaderDeserializationTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testMessageDecodingWithUnavailableClass() throws Exception {
        ClassLoader systemClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        String className = "UserClass";
        URLClassLoader userClassLoader = ClassLoaderUtils.compileAndLoadJava((File)temporaryFolder.newFolder(), (String)"UserClass.java", (String)"import java.io.Serializable;\npublic class UserClass implements Serializable {}");
        RemoteRpcInvocation method = new RemoteRpcInvocation("UserClass", "test", new Class[]{Integer.TYPE, Class.forName("UserClass", false, userClassLoader)}, new Object[]{1, Class.forName("UserClass", false, userClassLoader).newInstance()});
        SerializedValue serializedMethod = new SerializedValue((Object)method);
        this.expectedException.expect(ClassNotFoundException.class);
        this.expectedException.expect(CoreMatchers.allOf((Matcher)CoreMatchers.isA(ClassNotFoundException.class), (Matcher)Matchers.hasProperty((String)"suppressed", (Matcher)Matchers.hasItemInArray((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.isA(ClassNotFoundException.class), (Matcher)Matchers.hasProperty((String)"message", (Matcher)CoreMatchers.containsString((String)"Could not deserialize 1th parameter type of method test(int, ...).")))))));
        RemoteRpcInvocation deserializedMethod = (RemoteRpcInvocation)serializedMethod.deserializeValue(systemClassLoader);
        deserializedMethod.getMethodName();
        userClassLoader.close();
    }
}

