/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.DummyJobInformation;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.SerializedValue;

public class TaskDeploymentDescriptorBuilder {
    private JobID jobId;
    private TaskDeploymentDescriptor.MaybeOffloaded<JobInformation> serializedJobInformation;
    private TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation> serializedTaskInformation;
    private ExecutionAttemptID executionId;
    private AllocationID allocationId;
    private List<ResultPartitionDeploymentDescriptor> producedPartitions;
    private List<InputGateDeploymentDescriptor> inputGates;
    @Nullable
    private JobManagerTaskRestore taskRestore;

    private TaskDeploymentDescriptorBuilder(JobID jobId, String invokableClassName) throws IOException {
        TaskInformation taskInformation = new TaskInformation(new JobVertexID(), "test task", 1, 1, invokableClassName, new Configuration());
        this.jobId = jobId;
        this.serializedJobInformation = new TaskDeploymentDescriptor.NonOffloaded(new SerializedValue((Object)new DummyJobInformation(jobId, "DummyJob")));
        this.serializedTaskInformation = new TaskDeploymentDescriptor.NonOffloaded(new SerializedValue((Object)taskInformation));
        this.executionId = ExecutionGraphTestUtils.createExecutionAttemptId(taskInformation.getJobVertexId());
        this.allocationId = new AllocationID();
        this.producedPartitions = Collections.emptyList();
        this.inputGates = Collections.emptyList();
        this.taskRestore = null;
    }

    public TaskDeploymentDescriptorBuilder setSerializedJobInformation(TaskDeploymentDescriptor.MaybeOffloaded<JobInformation> serializedJobInformation) {
        this.serializedJobInformation = serializedJobInformation;
        return this;
    }

    public TaskDeploymentDescriptorBuilder setSerializedTaskInformation(TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation> serializedTaskInformation) {
        this.serializedTaskInformation = serializedTaskInformation;
        return this;
    }

    public TaskDeploymentDescriptorBuilder setJobId(JobID jobId) {
        this.jobId = jobId;
        return this;
    }

    public TaskDeploymentDescriptorBuilder setExecutionId(ExecutionAttemptID executionId) {
        this.executionId = executionId;
        return this;
    }

    public TaskDeploymentDescriptorBuilder setAllocationId(AllocationID allocationId) {
        this.allocationId = allocationId;
        return this;
    }

    public TaskDeploymentDescriptorBuilder setProducedPartitions(List<ResultPartitionDeploymentDescriptor> producedPartitions) {
        this.producedPartitions = producedPartitions;
        return this;
    }

    public TaskDeploymentDescriptorBuilder setInputGates(List<InputGateDeploymentDescriptor> inputGates) {
        this.inputGates = inputGates;
        return this;
    }

    public TaskDeploymentDescriptorBuilder setTaskRestore(@Nullable JobManagerTaskRestore taskRestore) {
        this.taskRestore = taskRestore;
        return this;
    }

    public TaskDeploymentDescriptor build() {
        return new TaskDeploymentDescriptor(this.jobId, this.serializedJobInformation, this.serializedTaskInformation, this.executionId, this.allocationId, this.taskRestore, this.producedPartitions, this.inputGates);
    }

    public static TaskDeploymentDescriptorBuilder newBuilder(JobID jobId, Class<?> invokableClass) throws IOException {
        return new TaskDeploymentDescriptorBuilder(jobId, invokableClass.getName());
    }
}

