/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.util.concurrent.FutureUtils;

public final class TestingCheckpointIDCounter
implements CheckpointIDCounter {
    private final Runnable startRunnable;
    private final Function<JobStatus, CompletableFuture<Void>> shutdownFunction;
    private final Supplier<Integer> getAndIncrementSupplier;
    private final Supplier<Integer> getSupplier;
    private final Consumer<Long> setCountConsumer;

    public static TestingCheckpointIDCounter createStoreWithShutdownCheckAndNoStartAction(CompletableFuture<JobStatus> shutdownFuture) {
        return TestingCheckpointIDCounter.builder().withStartRunnable(() -> {}).withShutdownConsumer(jobStatus -> {
            shutdownFuture.complete((JobStatus)jobStatus);
            return FutureUtils.completedVoidFuture();
        }).build();
    }

    private TestingCheckpointIDCounter(Runnable startRunnable, Function<JobStatus, CompletableFuture<Void>> shutdownFunction, Supplier<Integer> getAndIncrementSupplier, Supplier<Integer> getSupplier, Consumer<Long> setCountConsumer) {
        this.startRunnable = startRunnable;
        this.shutdownFunction = shutdownFunction;
        this.getAndIncrementSupplier = getAndIncrementSupplier;
        this.getSupplier = getSupplier;
        this.setCountConsumer = setCountConsumer;
    }

    public void start() {
        this.startRunnable.run();
    }

    public CompletableFuture<Void> shutdown(JobStatus jobStatus) {
        return this.shutdownFunction.apply(jobStatus);
    }

    public long getAndIncrement() {
        return this.getAndIncrementSupplier.get().intValue();
    }

    public long get() {
        return this.getSupplier.get().intValue();
    }

    public void setCount(long newId) {
        this.setCountConsumer.accept(newId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Runnable startRunnable;
        private Function<JobStatus, CompletableFuture<Void>> shutdownFunction;
        private Supplier<Integer> getAndIncrementSupplier;
        private Supplier<Integer> getSupplier;
        private Consumer<Long> setCountConsumer;

        public Builder withStartRunnable(Runnable startRunnable) {
            this.startRunnable = startRunnable;
            return this;
        }

        public Builder withShutdownConsumer(Function<JobStatus, CompletableFuture<Void>> shutdownFunction) {
            this.shutdownFunction = shutdownFunction;
            return this;
        }

        public Builder withGetAndIncrementSupplier(Supplier<Integer> getAndIncrementSupplier) {
            this.getAndIncrementSupplier = getAndIncrementSupplier;
            return this;
        }

        public Builder withGetSupplier(Supplier<Integer> getSupplier) {
            this.getSupplier = getSupplier;
            return this;
        }

        public Builder withSetCountConsumer(Consumer<Long> setCountConsumer) {
            this.setCountConsumer = setCountConsumer;
            return this;
        }

        public TestingCheckpointIDCounter build() {
            return new TestingCheckpointIDCounter(this.startRunnable, this.shutdownFunction, this.getAndIncrementSupplier, this.getSupplier, this.setCountConsumer);
        }
    }
}

