/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.ttl.TtlListState;
import org.apache.flink.runtime.state.ttl.TtlMergingStateTestContext;

abstract class TtlListStateTestContextBase<T>
extends TtlMergingStateTestContext<TtlListState<?, String, T>, List<T>, Iterable<T>> {
    private final TypeSerializer<T> serializer;

    TtlListStateTestContextBase(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void update(List<T> value) throws Exception {
        ((TtlListState)this.ttlState).addAll(value);
    }

    @Override
    public Iterable<T> get() throws Exception {
        return StreamSupport.stream(((TtlListState)this.ttlState).get().spliterator(), false).collect(Collectors.toList());
    }

    @Override
    public Object getOriginal() throws Exception {
        return ((InternalListState)((TtlListState)this.ttlState).original).get() == null ? this.emptyValue : ((InternalListState)((TtlListState)this.ttlState).original).get();
    }

    @Override
    public <US extends State, SV> StateDescriptor<US, SV> createStateDescriptor() {
        return new ListStateDescriptor(this.getName(), this.serializer);
    }

    @Override
    List<T> generateRandomUpdate() {
        int size = RANDOM.nextInt(5);
        return IntStream.range(0, size).mapToObj(this::generateRandomElement).collect(Collectors.toList());
    }

    abstract T generateRandomElement(int var1);

    @Override
    Iterable<T> getMergeResult(List<Tuple2<String, List<T>>> unexpiredUpdatesToMerge, List<Tuple2<String, List<T>>> finalUpdatesToMerge) {
        ArrayList result = new ArrayList();
        finalUpdatesToMerge.forEach(t -> result.addAll((Collection)t.f1));
        return result;
    }
}

