/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.LatencyTrackingAggregatingState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateTestBase;
import org.junit.Assert;
import org.junit.Test;

public class LatencyTrackingAggregatingStateTest
extends LatencyTrackingStateTestBase<Integer> {
    AggregatingStateDescriptor<Long, Long, Long> getStateDescriptor() {
        return new AggregatingStateDescriptor("aggregate", (AggregateFunction)new AggregateFunction<Long, Long, Long>(){
            private static final long serialVersionUID = 1L;

            public Long createAccumulator() {
                return 0L;
            }

            public Long add(Long value, Long accumulator) {
                return value + accumulator;
            }

            public Long getResult(Long accumulator) {
                return accumulator;
            }

            public Long merge(Long a, Long b) {
                return a + b;
            }
        }, Long.class);
    }

    @Override
    TypeSerializer<Integer> getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatencyTrackingAggregatingState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            LatencyTrackingAggregatingState latencyTrackingState = (LatencyTrackingAggregatingState)this.createLatencyTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            LatencyTrackingAggregatingState.AggregatingStateLatencyMetrics latencyTrackingStateMetric = (LatencyTrackingAggregatingState.AggregatingStateLatencyMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getAddCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getGetCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getMergeNamespaceCount());
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.add((Object)random.nextLong());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getAddCount());
                latencyTrackingState.get();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getGetCount());
                latencyTrackingState.mergeNamespaces((Object)VoidNamespace.INSTANCE, Collections.emptyList());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getMergeNamespaceCount());
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

