/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.security.token.HadoopFSDelegationTokenProvider;
import org.apache.flink.runtime.security.token.TestDelegationTokenIdentifier;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HadoopFSDelegationTokenProviderITCase {
    private static final long NOW = 100L;
    private static final String masterPrincipal = "MasterPrincipal";
    final Text tokenService1 = new Text("TEST_TOKEN_SERVICE1");
    final Text tokenService2 = new Text("TEST_TOKEN_SERVICE2");

    HadoopFSDelegationTokenProviderITCase() {
    }

    @Test
    public void getRenewerShouldReturnNullByDefault() throws Exception {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        provider.init(new Configuration());
        Assertions.assertNull((Object)provider.getRenewer());
    }

    @Test
    public void getRenewerShouldReturnConfiguredRenewer() throws Exception {
        String renewer = "testRenewer";
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        Configuration configuration = new Configuration();
        configuration.setString("security.kerberos.token.provider.hadoopfs.renewer", renewer);
        provider.init(configuration);
        Assertions.assertEquals((Object)renewer, (Object)provider.getRenewer());
    }

    @Test
    public void getTokenRenewalIntervalShouldReturnNoneWhenNoTokens() throws IOException {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider(){

            protected void obtainDelegationTokens(String renewer, Set<FileSystem> fileSystemsToAccess, Credentials credentials) {
            }
        };
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(0L), ZoneId.systemDefault());
        Assertions.assertEquals(Optional.empty(), (Object)provider.getTokenRenewalInterval(constantClock, Collections.emptySet()));
    }

    @Test
    public void getTokenRenewalIntervalShouldReturnMinWhenMultipleTokens() throws IOException {
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider(){

            protected void obtainDelegationTokens(String renewer, Set<FileSystem> fileSystemsToAccess, Credentials credentials) {
                TestDelegationTokenIdentifier tokenIdentifier1 = new TestDelegationTokenIdentifier(100L);
                credentials.addToken(HadoopFSDelegationTokenProviderITCase.this.tokenService1, (Token)new TestDelegationToken(HadoopFSDelegationTokenProviderITCase.this.tokenService1, tokenIdentifier1, 101L));
                TestDelegationTokenIdentifier tokenIdentifier2 = new TestDelegationTokenIdentifier(100L);
                credentials.addToken(HadoopFSDelegationTokenProviderITCase.this.tokenService2, (Token)new TestDelegationToken(HadoopFSDelegationTokenProviderITCase.this.tokenService2, tokenIdentifier2, 102L));
            }
        };
        Assertions.assertEquals(Optional.of(1L), (Object)provider.getTokenRenewalInterval(constantClock, Collections.emptySet()));
    }

    @Test
    public void getTokenRenewalDateShouldReturnNoneWhenNegativeRenewalInterval() {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(0L), ZoneId.systemDefault());
        Credentials credentials = new Credentials();
        Assertions.assertEquals(Optional.empty(), (Object)provider.getTokenRenewalDate(constantClock, credentials, -1L));
    }

    @Test
    public void getTokenRenewalDateShouldReturnNoneWhenNoTokens() {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(0L), ZoneId.systemDefault());
        Credentials credentials = new Credentials();
        Assertions.assertEquals(Optional.empty(), (Object)provider.getTokenRenewalDate(constantClock, credentials, 1L));
    }

    @Test
    public void getTokenRenewalDateShouldReturnMinWhenMultipleTokens() {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        Credentials credentials = new Credentials();
        TestDelegationTokenIdentifier tokenIdentifier1 = new TestDelegationTokenIdentifier(100L);
        credentials.addToken(this.tokenService1, (Token)new TestDelegationToken(this.tokenService1, tokenIdentifier1));
        TestDelegationTokenIdentifier tokenIdentifier2 = new TestDelegationTokenIdentifier(101L);
        credentials.addToken(this.tokenService2, (Token)new TestDelegationToken(this.tokenService2, tokenIdentifier2));
        Assertions.assertEquals(Optional.of(101L), (Object)provider.getTokenRenewalDate(constantClock, credentials, 1L));
    }

    @Test
    public void getIssueDateShouldReturnIssueDateWithFutureToken() {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        long issueDate = 101L;
        TestDelegationTokenIdentifier tokenIdentifier = new TestDelegationTokenIdentifier(issueDate);
        Assertions.assertEquals((long)issueDate, (long)provider.getIssueDate(constantClock, tokenIdentifier.getKind().toString(), (AbstractDelegationTokenIdentifier)tokenIdentifier));
    }

    @Test
    public void getIssueDateShouldReturnIssueDateWithPastToken() {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        long issueDate = 99L;
        TestDelegationTokenIdentifier tokenIdentifier = new TestDelegationTokenIdentifier(issueDate);
        Assertions.assertEquals((long)issueDate, (long)provider.getIssueDate(constantClock, tokenIdentifier.getKind().toString(), (AbstractDelegationTokenIdentifier)tokenIdentifier));
    }

    @Test
    public void getIssueDateShouldReturnNowWithInvalidToken() {
        HadoopFSDelegationTokenProvider provider = new HadoopFSDelegationTokenProvider();
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        long issueDate = -1L;
        TestDelegationTokenIdentifier tokenIdentifier = new TestDelegationTokenIdentifier(issueDate);
        Assertions.assertEquals((long)100L, (long)provider.getIssueDate(constantClock, tokenIdentifier.getKind().toString(), (AbstractDelegationTokenIdentifier)tokenIdentifier));
    }

    private class TestDelegationToken
    extends Token<TestDelegationTokenIdentifier> {
        private long newExpiration;

        public TestDelegationToken(Text tokenService, TestDelegationTokenIdentifier identifier, long newExpiration) {
            super(identifier.getBytes(), new byte[4], identifier.getKind(), tokenService);
            this.newExpiration = newExpiration;
        }

        public TestDelegationToken(Text tokenService, TestDelegationTokenIdentifier identifier) {
            this(tokenService, identifier, 0L);
        }

        public long renew(org.apache.hadoop.conf.Configuration conf) {
            return this.newExpiration;
        }
    }
}

