/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.Created;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.WaitingForResourcesTest;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CreatedTest
extends TestLogger {
    @Test
    public void testCancel() throws Exception {
        try (MockCreatedContext ctx = new MockCreatedContext();){
            Created created = new Created((Created.Context)ctx, this.log);
            ctx.setExpectFinished(WaitingForResourcesTest.assertNonNull());
            created.cancel();
        }
    }

    @Test
    public void testStartScheduling() throws Exception {
        try (MockCreatedContext ctx = new MockCreatedContext();){
            Created created = new Created((Created.Context)ctx, this.log);
            ctx.setExpectWaitingForResources();
            created.startScheduling();
        }
    }

    @Test
    public void testSuspend() throws Exception {
        try (MockCreatedContext ctx = new MockCreatedContext();){
            Created created = new Created((Created.Context)ctx, this.log);
            ctx.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.SUSPENDED)));
            created.suspend((Throwable)new RuntimeException("Suspend"));
        }
    }

    @Test
    public void testFailure() throws Exception {
        try (MockCreatedContext ctx = new MockCreatedContext();){
            Created created = new Created((Created.Context)ctx, this.log);
            ctx.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.FAILED)));
            created.handleGlobalFailure((Throwable)new RuntimeException("Global"));
        }
    }

    @Test
    public void testJobInformation() throws Exception {
        try (MockCreatedContext ctx = new MockCreatedContext();){
            Created created = new Created((Created.Context)ctx, this.log);
            ArchivedExecutionGraph job = created.getJob();
            Assert.assertThat((Object)job.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.INITIALIZING));
        }
    }

    static class MockCreatedContext
    implements Created.Context,
    AutoCloseable {
        private final StateValidator<ArchivedExecutionGraph> finishedStateValidator = new StateValidator("finished");
        private final StateValidator<Void> waitingForResourcesStateValidator = new StateValidator("WaitingForResources");

        MockCreatedContext() {
        }

        public void setExpectFinished(Consumer<ArchivedExecutionGraph> asserter) {
            this.finishedStateValidator.expectInput(asserter);
        }

        public void setExpectWaitingForResources() {
            this.waitingForResourcesStateValidator.expectInput(none -> {});
        }

        public void goToFinished(ArchivedExecutionGraph archivedExecutionGraph) {
            this.finishedStateValidator.validateInput(archivedExecutionGraph);
        }

        public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus jobStatus, @Nullable Throwable cause) {
            return ArchivedExecutionGraph.createSparseArchivedExecutionGraph((JobID)new JobID(), (String)"testJob", (JobStatus)jobStatus, (Throwable)cause, null, (long)0L);
        }

        public void goToWaitingForResources() {
            this.waitingForResourcesStateValidator.validateInput(null);
        }

        @Override
        public void close() throws Exception {
            this.finishedStateValidator.close();
            this.waitingForResourcesStateValidator.close();
        }
    }
}

