/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.scheduler.DefaultSyncPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.TestingInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSyncPreferredLocationsRetrieverTest
extends TestLogger {
    private static final ExecutionVertexID EV1 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV2 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV3 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV4 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV5 = ExecutionGraphTestUtils.createRandomExecutionVertexId();

    @Test
    public void testAvailableInputLocationRetrieval() {
        TestingInputsLocationsRetriever originalLocationRetriever = new TestingInputsLocationsRetriever.Builder().connectConsumerToProducer(EV5, EV1).connectConsumerToProducer(EV5, EV2).connectConsumerToProducer(EV5, EV3).connectConsumerToProducer(EV5, EV4).build();
        originalLocationRetriever.assignTaskManagerLocation(EV1);
        originalLocationRetriever.markScheduled(EV2);
        originalLocationRetriever.failTaskManagerLocation(EV3, new Throwable());
        originalLocationRetriever.cancelTaskManagerLocation(EV4);
        DefaultSyncPreferredLocationsRetriever locationsRetriever = new DefaultSyncPreferredLocationsRetriever(executionVertexId -> Optional.empty(), (InputsLocationsRetriever)originalLocationRetriever);
        Collection preferredLocations = locationsRetriever.getPreferredLocations(EV5, Collections.emptySet());
        TaskManagerLocation expectedLocation = originalLocationRetriever.getTaskManagerLocation(EV1).get().join();
        Assert.assertThat((Object)preferredLocations, (Matcher)Matchers.contains((Object[])new TaskManagerLocation[]{expectedLocation}));
    }
}

