/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.messages.json.JobResultDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobResultDeserializerTest
extends TestLogger {
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(JobResult.class, (JsonDeserializer)new JobResultDeserializer());
        this.objectMapper = JacksonMapperFactory.createObjectMapper();
        this.objectMapper.registerModule((Module)simpleModule);
    }

    @Test
    public void testDeserialization() throws Exception {
        JobResult jobResult = (JobResult)this.objectMapper.readValue("{\n\t\"id\": \"1bb5e8c7df49938733b7c6a73678de6a\",\n\t\"accumulator-results\": {},\n\t\"net-runtime\": 0,\n\t\"unknownfield\": \"foobar\"\n}", JobResult.class);
        Assert.assertThat((Object)jobResult.getJobId(), (Matcher)Matchers.equalTo((Object)JobID.fromHexString((String)"1bb5e8c7df49938733b7c6a73678de6a")));
        Assert.assertThat((Object)jobResult.getNetRuntime(), (Matcher)Matchers.equalTo((Object)0L));
        Assert.assertThat((Object)jobResult.getAccumulatorResults().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)jobResult.getSerializedThrowable().isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testInvalidType() throws Exception {
        try {
            this.objectMapper.readValue("{\n\t\"id\": \"1bb5e8c7df49938733b7c6a73678de6a\",\n\t\"net-runtime\": \"invalid\"\n}", JobResult.class);
        }
        catch (JsonMappingException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Expected token VALUE_NUMBER_INT (was VALUE_STRING)"));
        }
    }

    @Test
    public void testIncompleteJobResult() throws Exception {
        try {
            this.objectMapper.readValue("{\n\t\"id\": \"1bb5e8c7df49938733b7c6a73678de6a\"\n}", JobResult.class);
        }
        catch (JsonMappingException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Could not deserialize JobResult"));
        }
    }
}

