/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TaskIOMetricGroupTest {
    @Test
    public void testTaskIOMetricGroup() throws InterruptedException {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        TaskIOMetricGroup taskIO = task.getIOMetricGroup();
        taskIO.setEnableBusyTime(true);
        long startTime = System.currentTimeMillis();
        Assert.assertNotNull((Object)taskIO.getNumRecordsInCounter());
        Assert.assertNotNull((Object)taskIO.getNumRecordsOutCounter());
        SimpleCounter c1 = new SimpleCounter();
        c1.inc(32L);
        SimpleCounter c2 = new SimpleCounter();
        c2.inc(64L);
        taskIO.reuseRecordsInputCounter((Counter)c1);
        taskIO.reuseRecordsOutputCounter((Counter)c2);
        Assert.assertEquals((long)32L, (long)taskIO.getNumRecordsInCounter().getCount());
        Assert.assertEquals((long)64L, (long)taskIO.getNumRecordsOutCounter().getCount());
        taskIO.getNumBytesInCounter().inc(100L);
        taskIO.getNumBytesOutCounter().inc(250L);
        taskIO.getNumBuffersOutCounter().inc(3L);
        taskIO.getIdleTimeMsPerSecond().markStart();
        taskIO.getSoftBackPressuredTimePerSecond().markStart();
        long softSleepTime = 2L;
        Thread.sleep(softSleepTime);
        taskIO.getIdleTimeMsPerSecond().markEnd();
        taskIO.getSoftBackPressuredTimePerSecond().markEnd();
        long hardSleepTime = 4L;
        taskIO.getHardBackPressuredTimePerSecond().markStart();
        Thread.sleep(hardSleepTime);
        taskIO.getHardBackPressuredTimePerSecond().markEnd();
        IOMetrics io = taskIO.createSnapshot();
        Assert.assertEquals((long)32L, (long)io.getNumRecordsIn());
        Assert.assertEquals((long)64L, (long)io.getNumRecordsOut());
        Assert.assertEquals((long)100L, (long)io.getNumBytesIn());
        Assert.assertEquals((long)250L, (long)io.getNumBytesOut());
        Assert.assertEquals((long)3L, (long)taskIO.getNumBuffersOutCounter().getCount());
        Assert.assertEquals((long)taskIO.getIdleTimeMsPerSecond().getAccumulatedCount(), (long)io.getAccumulateIdleTime());
        Assert.assertEquals((long)(taskIO.getHardBackPressuredTimePerSecond().getAccumulatedCount() + taskIO.getSoftBackPressuredTimePerSecond().getAccumulatedCount()), (long)io.getAccumulateBackPressuredTime());
        Assert.assertThat((Object)io.getAccumulateBusyTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf((double)System.currentTimeMillis() - (double)startTime - (double)io.getAccumulateIdleTime() - (double)io.getAccumulateBackPressuredTime())));
        Assert.assertThat((Object)taskIO.getIdleTimeMsPerSecond().getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(softSleepTime)));
        Assert.assertThat((Object)taskIO.getSoftBackPressuredTimePerSecond().getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(softSleepTime)));
        Assert.assertThat((Object)taskIO.getHardBackPressuredTimePerSecond().getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(hardSleepTime)));
    }

    @Test
    public void testNumBytesProducedOfPartitionsMetrics() {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        TaskIOMetricGroup taskIO = task.getIOMetricGroup();
        SimpleCounter c1 = new SimpleCounter();
        c1.inc(32L);
        SimpleCounter c2 = new SimpleCounter();
        c2.inc(64L);
        IntermediateResultPartitionID resultPartitionID1 = new IntermediateResultPartitionID();
        IntermediateResultPartitionID resultPartitionID2 = new IntermediateResultPartitionID();
        taskIO.registerNumBytesProducedCounterForPartition(resultPartitionID1, (Counter)c1);
        taskIO.registerNumBytesProducedCounterForPartition(resultPartitionID2, (Counter)c2);
        Map numBytesProducedOfPartitions = taskIO.createSnapshot().getNumBytesProducedOfPartitions();
        Assert.assertEquals((long)2L, (long)numBytesProducedOfPartitions.size());
        Assert.assertEquals((long)32L, (long)((Long)numBytesProducedOfPartitions.get(resultPartitionID1)));
        Assert.assertEquals((long)64L, (long)((Long)numBytesProducedOfPartitions.get(resultPartitionID2)));
    }
}

