/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndex;
import org.apache.flink.util.function.TriFunction;

public class TestingFileDataIndex
implements HsFileDataIndex {
    private final TriFunction<Integer, Integer, Integer, Optional<HsFileDataIndex.ReadableRegion>> getReadableRegionFunction;
    private final Consumer<List<HsFileDataIndex.SpilledBuffer>> addBuffersConsumer;
    private final BiConsumer<Integer, Integer> markBufferReadableConsumer;

    private TestingFileDataIndex(TriFunction<Integer, Integer, Integer, Optional<HsFileDataIndex.ReadableRegion>> getReadableRegionFunction, Consumer<List<HsFileDataIndex.SpilledBuffer>> addBuffersConsumer, BiConsumer<Integer, Integer> markBufferReadableConsumer) {
        this.getReadableRegionFunction = getReadableRegionFunction;
        this.addBuffersConsumer = addBuffersConsumer;
        this.markBufferReadableConsumer = markBufferReadableConsumer;
    }

    public Optional<HsFileDataIndex.ReadableRegion> getReadableRegion(int subpartitionId, int bufferIndex, int consumingOffset) {
        return (Optional)this.getReadableRegionFunction.apply((Object)subpartitionId, (Object)bufferIndex, (Object)consumingOffset);
    }

    public void addBuffers(List<HsFileDataIndex.SpilledBuffer> spilledBuffers) {
        this.addBuffersConsumer.accept(spilledBuffers);
    }

    public void markBufferReleased(int subpartitionId, int bufferIndex) {
        this.markBufferReadableConsumer.accept(subpartitionId, bufferIndex);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TriFunction<Integer, Integer, Integer, Optional<HsFileDataIndex.ReadableRegion>> getReadableRegionFunction = (ignore1, ignore2, ignore3) -> Optional.empty();
        private Consumer<List<HsFileDataIndex.SpilledBuffer>> addBuffersConsumer = ignore -> {};
        private BiConsumer<Integer, Integer> markBufferReadableConsumer = (ignore1, ignore2) -> {};

        private Builder() {
        }

        public Builder setGetReadableRegionFunction(TriFunction<Integer, Integer, Integer, Optional<HsFileDataIndex.ReadableRegion>> getReadableRegionFunction) {
            this.getReadableRegionFunction = getReadableRegionFunction;
            return this;
        }

        public Builder setAddBuffersConsumer(Consumer<List<HsFileDataIndex.SpilledBuffer>> addBuffersConsumer) {
            this.addBuffersConsumer = addBuffersConsumer;
            return this;
        }

        public Builder setMarkBufferReadableConsumer(BiConsumer<Integer, Integer> markBufferReadableConsumer) {
            this.markBufferReadableConsumer = markBufferReadableConsumer;
            return this;
        }

        public TestingFileDataIndex build() {
            return new TestingFileDataIndex(this.getReadableRegionFunction, this.addBuffersConsumer, this.markBufferReadableConsumer);
        }
    }
}

