/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSelectiveSpillingStrategy;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSpillingInfoProvider;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSpillingStrategy;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.TestingSpillingInfoProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class HsSelectiveSpillingStrategyTest {
    public static final int NUM_SUBPARTITIONS = 3;
    public static final float SELECTIVE_SPILL_THRESHOLD = 0.7f;
    public static final float SELECTIVE_SPILL_BUFFER_RATIO = 0.3f;
    private final HsSpillingStrategy spillStrategy = new HsSelectiveSpillingStrategy(HybridShuffleConfiguration.builder((int)3, (int)1).setSelectiveStrategySpillThreshold(0.7f).setSelectiveStrategySpillBufferRatio(0.3f).build());

    HsSelectiveSpillingStrategyTest() {
    }

    @Test
    void testOnBufferFinished() {
        Optional finishedDecision = this.spillStrategy.onBufferFinished(5, 10);
        Assertions.assertThat((Optional)finishedDecision).hasValue((Object)HsSpillingStrategy.Decision.NO_ACTION);
    }

    @Test
    void testOnBufferConsumed() {
        BufferIndexAndChannel bufferIndexAndChannel = new BufferIndexAndChannel(0, 0);
        Optional consumedDecision = this.spillStrategy.onBufferConsumed(bufferIndexAndChannel);
        Assertions.assertThat((Optional)consumedDecision).hasValueSatisfying(decision -> {
            ((MapAssert)Assertions.assertThat((Map)decision.getBufferToRelease()).hasSize(1)).hasEntrySatisfying((Object)0, list -> {
                ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)list).containsExactly((Object[])new BufferIndexAndChannel[]{bufferIndexAndChannel});
            });
            Assertions.assertThat((Map)decision.getBufferToSpill()).isEmpty();
        });
    }

    @Test
    void testOnUsedMemoryLow() {
        int bufferPoolSize = 10;
        int bufferThreshold = 7;
        Optional memoryUsageChangedDecision = this.spillStrategy.onMemoryUsageChanged(6, 10);
        Assertions.assertThat((Optional)memoryUsageChangedDecision).hasValue((Object)HsSpillingStrategy.Decision.NO_ACTION);
    }

    @Test
    void testOnUsedMemoryHigh() {
        boolean subpartition1 = false;
        boolean subpartition2 = true;
        int subpartition3 = 2;
        int progress1 = 10;
        int progress2 = 20;
        int progress3 = 30;
        List<BufferIndexAndChannel> subpartitionBuffer1 = HybridShuffleTestUtils.createBufferIndexAndChannelsList(0, 10, 13, 16, 19);
        List<BufferIndexAndChannel> subpartitionBuffer2 = HybridShuffleTestUtils.createBufferIndexAndChannelsList(1, 21, 24, 27);
        List<BufferIndexAndChannel> subpartitionBuffer3 = HybridShuffleTestUtils.createBufferIndexAndChannelsList(2, 32, 35, 38);
        int bufferPoolSize = 10;
        int totalBuffers = 10;
        TestingSpillingInfoProvider spillInfoProvider = TestingSpillingInfoProvider.builder().setGetNumSubpartitionsSupplier(() -> 3).addSubpartitionBuffers(0, subpartitionBuffer1).addSubpartitionBuffers(1, subpartitionBuffer2).addSubpartitionBuffers(2, subpartitionBuffer3).addSpillBuffers(0, Collections.singletonList(3)).setGetNextBufferIndexToConsumeSupplier(() -> Arrays.asList(10, 20, 30)).setGetPoolSizeSupplier(() -> 10).setGetNumTotalRequestedBuffersSupplier(() -> 10).build();
        Optional decision = this.spillStrategy.onMemoryUsageChanged(10, 10);
        Assertions.assertThat((Optional)decision).isNotPresent();
        HsSpillingStrategy.Decision globalDecision = this.spillStrategy.decideActionWithGlobalInfo((HsSpillingInfoProvider)spillInfoProvider);
        HashMap<Integer, List<BufferIndexAndChannel>> expectedBuffers = new HashMap<Integer, List<BufferIndexAndChannel>>();
        expectedBuffers.put(0, subpartitionBuffer1.subList(2, 3));
        expectedBuffers.put(1, subpartitionBuffer2.subList(2, 3));
        expectedBuffers.put(2, subpartitionBuffer3.subList(2, 3));
        Assertions.assertThat((Map)globalDecision.getBufferToSpill()).isEqualTo(expectedBuffers);
        Assertions.assertThat((Map)globalDecision.getBufferToRelease()).isEqualTo(expectedBuffers);
    }

    @Test
    void testOnResultPartitionClosed() {
        boolean subpartition1 = false;
        boolean subpartition2 = true;
        List<BufferIndexAndChannel> subpartitionBuffer1 = HybridShuffleTestUtils.createBufferIndexAndChannelsList(0, 0, 1, 2, 3);
        List<BufferIndexAndChannel> subpartitionBuffer2 = HybridShuffleTestUtils.createBufferIndexAndChannelsList(1, 0, 1, 2);
        TestingSpillingInfoProvider spillInfoProvider = TestingSpillingInfoProvider.builder().setGetNumSubpartitionsSupplier(() -> 2).addSubpartitionBuffers(0, subpartitionBuffer1).addSubpartitionBuffers(1, subpartitionBuffer2).addSpillBuffers(0, Arrays.asList(2, 3)).addConsumedBuffers(0, Collections.singletonList(0)).addSpillBuffers(1, Collections.singletonList(2)).build();
        HsSpillingStrategy.Decision decision = this.spillStrategy.onResultPartitionClosed((HsSpillingInfoProvider)spillInfoProvider);
        HashMap<Integer, List<BufferIndexAndChannel>> expectedToSpillBuffers = new HashMap<Integer, List<BufferIndexAndChannel>>();
        expectedToSpillBuffers.put(0, subpartitionBuffer1.subList(0, 2));
        expectedToSpillBuffers.put(1, subpartitionBuffer2.subList(0, 2));
        Assertions.assertThat((Map)decision.getBufferToSpill()).isEqualTo(expectedToSpillBuffers);
        HashMap<Integer, List<BufferIndexAndChannel>> expectedToReleaseBuffers = new HashMap<Integer, List<BufferIndexAndChannel>>();
        expectedToReleaseBuffers.put(0, subpartitionBuffer1.subList(0, 4));
        expectedToReleaseBuffers.put(1, subpartitionBuffer2.subList(0, 3));
        Assertions.assertThat((Map)decision.getBufferToRelease()).isEqualTo(expectedToReleaseBuffers);
    }
}

