/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.junit.Assert;
import org.junit.Before;

public abstract class InputGateTestBase {
    int gateIndex;

    @Before
    public void resetGateIndex() {
        this.gateIndex = 0;
    }

    protected void testIsAvailable(InputGate inputGateToTest, SingleInputGate inputGateToNotify, TestInputChannel inputChannelWithNewData) throws Exception {
        Assert.assertFalse((boolean)inputGateToTest.getAvailableFuture().isDone());
        Assert.assertFalse((boolean)inputGateToTest.pollNext().isPresent());
        CompletableFuture future = inputGateToTest.getAvailableFuture();
        Assert.assertFalse((boolean)inputGateToTest.getAvailableFuture().isDone());
        Assert.assertFalse((boolean)inputGateToTest.pollNext().isPresent());
        Assert.assertEquals((Object)future, (Object)inputGateToTest.getAvailableFuture());
        inputChannelWithNewData.readBuffer();
        inputGateToNotify.notifyChannelNonEmpty((InputChannel)inputChannelWithNewData);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)inputGateToTest.getAvailableFuture().isDone());
        Assert.assertEquals((Object)PullingAsyncDataInput.AVAILABLE, (Object)inputGateToTest.getAvailableFuture());
    }

    protected void testIsAvailableAfterFinished(InputGate inputGateToTest, Runnable endOfPartitionEvent) throws Exception {
        CompletableFuture available = inputGateToTest.getAvailableFuture();
        Assert.assertFalse((boolean)available.isDone());
        Assert.assertFalse((boolean)inputGateToTest.pollNext().isPresent());
        endOfPartitionEvent.run();
        Assert.assertTrue((boolean)inputGateToTest.pollNext().isPresent());
        Assert.assertTrue((boolean)available.isDone());
        Assert.assertTrue((boolean)inputGateToTest.getAvailableFuture().isDone());
        Assert.assertEquals((Object)PullingAsyncDataInput.AVAILABLE, (Object)inputGateToTest.getAvailableFuture());
    }

    protected SingleInputGate createInputGate() {
        return this.createInputGate(2);
    }

    protected SingleInputGate createInputGate(int numberOfInputChannels) {
        return this.createInputGate(null, numberOfInputChannels, ResultPartitionType.PIPELINED);
    }

    protected SingleInputGate createInputGate(NettyShuffleEnvironment environment, int numberOfInputChannels, ResultPartitionType partitionType) {
        SingleInputGateBuilder builder = new SingleInputGateBuilder().setNumberOfChannels(numberOfInputChannels).setSingleInputGateIndex(this.gateIndex++).setResultPartitionType(partitionType);
        if (environment != null) {
            builder = builder.setupBufferPoolFactory(environment);
        }
        SingleInputGate inputGate = builder.build();
        Assert.assertEquals((Object)partitionType, (Object)inputGate.getConsumedPartitionType());
        return inputGate;
    }
}

