/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.api.serialization.NonSpanningWrapper;
import org.apache.flink.runtime.io.network.api.serialization.SpanningWrapper;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.CloseableIterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SpanningWrapperTest {
    private static final Random random = new Random();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testLargeUnconsumedSegment() throws Exception {
        int recordLen = 100;
        int firstChunk = (int)((double)recordLen * 0.9);
        int spillingThreshold = (int)((double)firstChunk * 0.9);
        byte[] record1 = this.recordBytes(recordLen);
        byte[] record2 = this.recordBytes(recordLen * 2);
        File canNotEecutableFile = this.folder.newFolder();
        canNotEecutableFile.setExecutable(false);
        SpanningWrapper spanningWrapper = new SpanningWrapper(new String[]{this.folder.newFolder().getAbsolutePath(), canNotEecutableFile.getAbsolutePath() + File.separator + "pathdonotexit"}, spillingThreshold, recordLen);
        spanningWrapper.transferFrom(this.wrapNonSpanning(record1, firstChunk), recordLen);
        spanningWrapper.addNextChunkFromMemorySegment(MemorySegmentFactory.wrap((byte[])record1), firstChunk, recordLen - firstChunk + 4);
        spanningWrapper.addNextChunkFromMemorySegment(MemorySegmentFactory.wrap((byte[])record2), 0, record2.length);
        CloseableIterator unconsumedSegment = spanningWrapper.getUnconsumedSegment();
        spanningWrapper.getInputView().readFully(new byte[recordLen], 0, recordLen);
        spanningWrapper.transferLeftOverTo(new NonSpanningWrapper());
        spanningWrapper.transferFrom(this.wrapNonSpanning(this.recordBytes(recordLen), recordLen), recordLen);
        canNotEecutableFile.setExecutable(true);
        Assert.assertArrayEquals((byte[])this.concat(record1, record2), (byte[])this.toByteArray((CloseableIterator<Buffer>)unconsumedSegment));
    }

    private byte[] recordBytes(int recordLen) {
        byte[] inputData = this.randomBytes(recordLen + 4);
        for (int i = 0; i < 4; ++i) {
            inputData[4 - i - 1] = (byte)(recordLen >>> i * 8);
        }
        return inputData;
    }

    private NonSpanningWrapper wrapNonSpanning(byte[] bytes, int len) {
        NonSpanningWrapper nonSpanningWrapper = new NonSpanningWrapper();
        MemorySegment segment = MemorySegmentFactory.wrap((byte[])bytes);
        nonSpanningWrapper.initializeFromMemorySegment(segment, 0, len);
        nonSpanningWrapper.readInt();
        return nonSpanningWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(CloseableIterator<Buffer> unconsumed) {
        ArrayList buffers = new ArrayList();
        try {
            unconsumed.forEachRemaining(buffers::add);
            byte[] result = new byte[buffers.stream().mapToInt(Buffer::readableBytes).sum()];
            int offset = 0;
            for (Buffer buffer : buffers) {
                int len = buffer.readableBytes();
                buffer.getNioBuffer(0, len).get(result, offset, len);
                offset += len;
            }
            Object object = result;
            return object;
        }
        finally {
            buffers.forEach(Buffer::recycleBuffer);
        }
    }

    private byte[] randomBytes(int length) {
        byte[] inputData = new byte[length];
        random.nextBytes(inputData);
        return inputData;
    }

    private byte[] concat(byte[] input1, byte[] input2) {
        byte[] expected = new byte[input1.length + input2.length];
        System.arraycopy(input1, 0, expected, 0, input1.length);
        System.arraycopy(input2, 0, expected, input1.length, input2.length);
        return expected;
    }
}

