/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManagerFactory;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingClusterEntrypointProcess
extends TestJvmProcess {
    private final File markerFile;

    public TestingClusterEntrypointProcess(File markerFile) throws Exception {
        this.markerFile = (File)Preconditions.checkNotNull((Object)markerFile, (String)"marker file");
    }

    @Override
    public String getName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String[] getJvmArgs() {
        return new String[]{this.markerFile.getAbsolutePath()};
    }

    @Override
    public String getEntryPointClassName() {
        return TestingClusterEntrypointProcessEntryPoint.class.getName();
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    private static class TestingClusterEntrypoint
    extends ClusterEntrypoint {
        private final File markerFile;

        protected TestingClusterEntrypoint(Configuration configuration, File markerFile) {
            super(configuration);
            this.markerFile = markerFile;
        }

        protected DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration configuration) throws IOException {
            return DefaultDispatcherResourceManagerComponentFactory.createSessionComponentFactory((ResourceManagerFactory)StandaloneResourceManagerFactory.getInstance());
        }

        protected ExecutionGraphInfoStore createSerializableExecutionGraphStore(Configuration configuration, ScheduledExecutor scheduledExecutor) throws IOException {
            return new MemoryExecutionGraphInfoStore();
        }

        public CompletableFuture<Void> closeAsync() {
            return super.closeAsync().thenRun(() -> {
                LOG.info("Deleting markerFile {}", (Object)this.markerFile);
                IOUtils.deleteFileQuietly((Path)this.markerFile.toPath());
            });
        }
    }

    public static class TestingClusterEntrypointProcessEntryPoint {
        private static final Logger LOG = LoggerFactory.getLogger(TestingClusterEntrypointProcessEntryPoint.class);

        public static void main(String[] args) {
            try {
                File markerFile = new File(args[0]);
                Configuration config = new Configuration();
                config.setInteger(JobManagerOptions.PORT, 0);
                config.setString(RestOptions.BIND_PORT, "0");
                TestingClusterEntrypoint clusterEntrypoint = new TestingClusterEntrypoint(config, markerFile);
                SignalHandler.register((Logger)LOG);
                clusterEntrypoint.startCluster();
                TestJvmProcess.touchFile(markerFile);
                int returnCode = ((ApplicationStatus)clusterEntrypoint.getTerminationFuture().get()).processExitCode();
                System.exit(returnCode);
            }
            catch (Throwable t) {
                LOG.error("Failed to start TestingClusterEntrypoint process", t);
                System.exit(1);
            }
        }
    }
}

