/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.blob.NoOpTaskExecutorBlobService;
import org.apache.flink.runtime.blob.TaskExecutorBlobService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcServiceResource;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.testutils.WorkingDirectoryResource;
import org.apache.flink.shaded.guava30.com.google.common.collect.Sets;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIn;
import org.hamcrest.core.Every;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskManagerRunnerStartupTest
extends TestLogger {
    private static final String LOCAL_HOST = "localhost";
    @ClassRule
    public static final TestingRpcServiceResource RPC_SERVICE_RESOURCE = new TestingRpcServiceResource();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    @ClassRule
    public static final WorkingDirectoryResource WORKING_DIRECTORY_RESOURCE = new WorkingDirectoryResource();
    private final RpcService rpcService = RPC_SERVICE_RESOURCE.getTestingRpcService();
    private TestingHighAvailabilityServices highAvailabilityServices;

    @Before
    public void setupTest() {
        this.highAvailabilityServices = new TestingHighAvailabilityServices();
        this.highAvailabilityServices.setResourceManagerLeaderRetriever(new SettableLeaderRetrievalService());
    }

    @After
    public void tearDownTest() throws Exception {
        this.highAvailabilityServices.closeAndCleanupAllData();
        this.highAvailabilityServices = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIODirectoryNotWritable() throws Exception {
        File nonWritable = this.tempFolder.newFolder();
        Assume.assumeTrue((String)"Cannot create non-writable temporary file directory. Skipping test.", (boolean)nonWritable.setWritable(false, false));
        try {
            Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
            cfg.setString(CoreOptions.TMP_DIRS, nonWritable.getAbsolutePath());
            try {
                TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, WORKING_DIRECTORY_RESOURCE.createNewWorkingDirectory());
                Assert.fail((String)"Should fail synchronously with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            nonWritable.setWritable(true, false);
            try {
                FileUtils.deleteDirectory((File)nonWritable);
            }
            catch (IOException iOException) {}
        }
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testMemoryConfigWrong() throws Exception {
        Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
        cfg.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"100m"));
        cfg.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"10m"));
        TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, WORKING_DIRECTORY_RESOURCE.createNewWorkingDirectory());
    }

    @Test
    public void testStartupWhenNetworkStackFailsToInitialize() throws Exception {
        ServerSocket blocker = new ServerSocket(0, 50, InetAddress.getByName(LOCAL_HOST));
        try {
            Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
            cfg.setInteger(NettyShuffleEnvironmentOptions.DATA_PORT, blocker.getLocalPort());
            cfg.setString(TaskManagerOptions.BIND_HOST, LOCAL_HOST);
            TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, WORKING_DIRECTORY_RESOURCE.createNewWorkingDirectory());
            Assert.fail((String)"Should throw IOException when the network stack cannot be initialized.");
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)blocker);
        }
    }

    @Test
    public void testMetricInitialization() throws Exception {
        Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
        ArrayList registeredMetrics = new ArrayList();
        TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, WORKING_DIRECTORY_RESOURCE.createNewWorkingDirectory(), TestingMetricRegistry.builder().setRegisterConsumer((metric, metricName, group) -> registeredMetrics.add(group.getMetricIdentifier(metricName))).setScopeFormats(ScopeFormats.fromConfig((Configuration)cfg)).build());
        HashSet expectedTaskManagerMetricsWithoutTaskManagerId = Sets.newHashSet((Object[])new String[]{".taskmanager..Status.JVM.ClassLoader.ClassesLoaded", ".taskmanager..Status.JVM.ClassLoader.ClassesUnloaded", ".taskmanager..Status.JVM.Memory.Heap.Used", ".taskmanager..Status.JVM.Memory.Heap.Committed", ".taskmanager..Status.JVM.Memory.Heap.Max", ".taskmanager..Status.JVM.Memory.NonHeap.Used", ".taskmanager..Status.JVM.Memory.NonHeap.Committed", ".taskmanager..Status.JVM.Memory.NonHeap.Max", ".taskmanager..Status.JVM.Memory.Direct.Count", ".taskmanager..Status.JVM.Memory.Direct.MemoryUsed", ".taskmanager..Status.JVM.Memory.Direct.TotalCapacity", ".taskmanager..Status.JVM.Memory.Mapped.Count", ".taskmanager..Status.JVM.Memory.Mapped.MemoryUsed", ".taskmanager..Status.JVM.Memory.Mapped.TotalCapacity", ".taskmanager..Status.Flink.Memory.Managed.Used", ".taskmanager..Status.Flink.Memory.Managed.Total", ".taskmanager..Status.JVM.Threads.Count", ".taskmanager..Status.JVM.CPU.Load", ".taskmanager..Status.JVM.CPU.Time", ".taskmanager..Status.Network.TotalMemorySegments", ".taskmanager..Status.Network.AvailableMemorySegments", ".taskmanager..Status.Shuffle.Netty.TotalMemorySegments", ".taskmanager..Status.Shuffle.Netty.TotalMemory", ".taskmanager..Status.Shuffle.Netty.AvailableMemorySegments", ".taskmanager..Status.Shuffle.Netty.AvailableMemory", ".taskmanager..Status.Shuffle.Netty.UsedMemorySegments", ".taskmanager..Status.Shuffle.Netty.UsedMemory"});
        Pattern pattern = Pattern.compile("\\.taskmanager\\.([^.]+)\\..*");
        Set registeredMetricsWithoutTaskManagerId = registeredMetrics.stream().map(pattern::matcher).flatMap(matcher -> matcher.find() ? Stream.of(matcher.group(0).replaceAll(matcher.group(1), "")) : Stream.empty()).collect(Collectors.toSet());
        Assert.assertThat((Object)expectedTaskManagerMetricsWithoutTaskManagerId, (Matcher)Every.everyItem((Matcher)IsIn.isIn(registeredMetricsWithoutTaskManagerId)));
    }

    private static Configuration createFlinkConfiguration() {
        return TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)new Configuration());
    }

    private static void startTaskManager(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, WorkingDirectory workingDirectory) throws Exception {
        TaskManagerRunnerStartupTest.startTaskManager(configuration, rpcService, highAvailabilityServices, workingDirectory, NoOpMetricRegistry.INSTANCE);
    }

    private static void startTaskManager(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, WorkingDirectory workingDirectory, MetricRegistry metricRegistry) throws Exception {
        TaskManagerRunner.startTaskManager((Configuration)configuration, (ResourceID)ResourceID.generate(), (RpcService)rpcService, (HighAvailabilityServices)highAvailabilityServices, (HeartbeatServices)new TestingHeartbeatServices(), (MetricRegistry)metricRegistry, (TaskExecutorBlobService)NoOpTaskExecutorBlobService.INSTANCE, (boolean)false, (ExternalResourceInfoProvider)ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES, (WorkingDirectory)workingDirectory, error -> {});
    }
}

