/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.runtime.state.ttl.TtlValueMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TtlSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<TtlValue<String>, TtlValue<String>> {
    public TtlSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<TtlValue<String>, TtlValue<String>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("ttl-serializer", flinkVersion, TtlSerializerSetup.class, TtlSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class TtlSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TtlValue<String>> {
        public TypeSerializer<TtlValue<String>> createUpgradedSerializer() {
            return new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        public Matcher<TtlValue<String>> testDataMatcher() {
            return TtlValueMatchers.ttlValue(Matchers.is((Object)"hello Gordon"), (Matcher<Long>)Matchers.is((Object)13L));
        }

        public Matcher<TypeSerializerSchemaCompatibility<TtlValue<String>>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class TtlSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TtlValue<String>> {
        public TypeSerializer<TtlValue<String>> createPriorSerializer() {
            return new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        public TtlValue<String> createTestData() {
            return new TtlValue((Object)"hello Gordon", 13L);
        }
    }
}

