/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.testutils;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStateToolset;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class BackendForTestStream
extends MemoryStateBackend {
    private static final long serialVersionUID = 1L;
    private final TestFactory streamFactory;

    public BackendForTestStream(TestFactory streamFactory) {
        this.streamFactory = (TestFactory)Preconditions.checkNotNull((Object)streamFactory);
    }

    public BackendForTestStream(StreamFactory streamSupplier) {
        this(new TestFactory(streamSupplier));
    }

    public MemoryStateBackend configure(ReadableConfig config, ClassLoader classLoader) {
        return this;
    }

    public CheckpointStorageAccess createCheckpointStorage(JobID jobId) {
        return new TestCheckpointStorageAccess();
    }

    private static final class TestFactory
    implements CheckpointStreamFactory,
    Serializable {
        private final StreamFactory streamFactory;

        TestFactory(StreamFactory streamFactory) {
            this.streamFactory = streamFactory;
        }

        public CheckpointStateOutputStream createCheckpointStateOutputStream(CheckpointedStateScope scope) throws IOException {
            return (CheckpointStateOutputStream)this.streamFactory.get();
        }

        public boolean canFastDuplicate(StreamStateHandle stateHandle, CheckpointedStateScope scope) {
            return false;
        }

        public List<StreamStateHandle> duplicate(List<StreamStateHandle> stateHandles, CheckpointedStateScope scope) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private final class TestCheckpointStorageAccess
    implements CheckpointStorageAccess {
        private TestCheckpointStorageAccess() {
        }

        public boolean supportsHighlyAvailableStorage() {
            throw new UnsupportedOperationException();
        }

        public boolean hasDefaultSavepointLocation() {
            throw new UnsupportedOperationException();
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) {
            throw new UnsupportedOperationException();
        }

        public void initializeBaseLocationsForCheckpoint() {
            throw new UnsupportedOperationException();
        }

        public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) {
            throw new UnsupportedOperationException();
        }

        public CheckpointStorageLocation initializeLocationForSavepoint(long checkpointId, @Nullable String externalLocationPointer) {
            throw new UnsupportedOperationException();
        }

        public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) {
            return BackendForTestStream.this.streamFactory;
        }

        public CheckpointStateOutputStream createTaskOwnedStateStream() {
            throw new UnsupportedOperationException();
        }

        public CheckpointStateToolset createTaskOwnedCheckpointStateToolset() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface StreamFactory
    extends SupplierWithException<CheckpointStateOutputStream, IOException>,
    Serializable {
    }
}

