/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import java.io.IOException;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.FsStateBackendEntropyTest;
import org.apache.flink.runtime.state.filesystem.RelativeFileStateHandle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FsCheckpointStreamFactoryTest {
    @TempDir
    private java.nio.file.Path exclusiveStateDir;
    @TempDir
    private java.nio.file.Path sharedStateDir;

    @Test
    public void testWriteFlushesIfAboveThreshold() throws IOException {
        int fileSizeThreshold = 100;
        FsCheckpointStreamFactory factory = this.createFactory(FileSystem.getLocalFileSystem(), fileSizeThreshold, fileSizeThreshold);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(new byte[fileSizeThreshold]);
        File[] files = new File(this.exclusiveStateDir.toUri()).listFiles();
        Assertions.assertEquals((int)1, (int)files.length);
        File file = files[0];
        Assertions.assertEquals((long)fileSizeThreshold, (long)file.length());
        stream.write(new byte[fileSizeThreshold - 1]);
        stream.write(127);
        Assertions.assertEquals((long)fileSizeThreshold, (long)file.length());
    }

    @Test
    public void testExclusiveStateHasRelativePathHandles() throws IOException {
        FsCheckpointStreamFactory factory = this.createFactory(FileSystem.getLocalFileSystem(), 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(1657);
        StreamStateHandle handle = stream.closeAndGetHandle();
        MatcherAssert.assertThat((Object)handle, (Matcher)Matchers.instanceOf(RelativeFileStateHandle.class));
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.exclusiveStateDir, ((RelativeFileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    public void testSharedStateHasAbsolutePathHandles() throws IOException {
        FsCheckpointStreamFactory factory = this.createFactory(FileSystem.getLocalFileSystem(), 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.SHARED);
        stream.write(0);
        StreamStateHandle handle = stream.closeAndGetHandle();
        MatcherAssert.assertThat((Object)handle, (Matcher)Matchers.instanceOf(FileStateHandle.class));
        MatcherAssert.assertThat((Object)handle, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(RelativeFileStateHandle.class)));
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.sharedStateDir, ((FileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    public void testEntropyMakesExclusiveStateAbsolutePaths() throws IOException {
        FsCheckpointStreamFactory factory = this.createFactory((FileSystem)new FsStateBackendEntropyTest.TestEntropyAwareFs(), 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(0);
        StreamStateHandle handle = stream.closeAndGetHandle();
        MatcherAssert.assertThat((Object)handle, (Matcher)Matchers.instanceOf(FileStateHandle.class));
        MatcherAssert.assertThat((Object)handle, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(RelativeFileStateHandle.class)));
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.exclusiveStateDir, ((FileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    public void testFSWithDisabledEntropyHasRelativePaths() throws IOException {
        FsCheckpointStreamFactory factory = this.createFactory((FileSystem)new DisabledEntropyFS(), 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(0);
        StreamStateHandle handle = stream.closeAndGetHandle();
        MatcherAssert.assertThat((Object)handle, (Matcher)Matchers.instanceOf(RelativeFileStateHandle.class));
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.exclusiveStateDir, ((RelativeFileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    public void testFlushUnderThreshold() throws IOException {
        this.flushAndVerify(10, 10, true);
    }

    @Test
    public void testFlushAboveThreshold() throws IOException {
        this.flushAndVerify(10, 11, false);
    }

    private void flushAndVerify(int minFileSize, int bytesToFlush, boolean expectEmpty) throws IOException {
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = this.createFactory((FileSystem)new FsStateBackendEntropyTest.TestEntropyAwareFs(), minFileSize).createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(new byte[bytesToFlush], 0, bytesToFlush);
        stream.flush();
        Assertions.assertEquals((int)(expectEmpty ? 0 : 1), (int)new File(this.exclusiveStateDir.toUri()).listFiles().length);
    }

    private static void assertPathsEqual(java.nio.file.Path expected, Path actual) {
        Path reNormalizedExpected = new Path(new Path(expected.toUri()).toString());
        Assertions.assertEquals((Object)reNormalizedExpected, (Object)actual);
    }

    private FsCheckpointStreamFactory createFactory(FileSystem fs, int fileSizeThreshold) {
        return this.createFactory(fs, fileSizeThreshold, 4096);
    }

    private FsCheckpointStreamFactory createFactory(FileSystem fs, int fileSizeThreshold, int bufferSize) {
        return new FsCheckpointStreamFactory(fs, new Path(this.exclusiveStateDir.toUri()), new Path(this.sharedStateDir.toUri()), fileSizeThreshold, bufferSize);
    }

    private static final class DisabledEntropyFS
    extends LocalFileSystem
    implements EntropyInjectingFileSystem {
        private DisabledEntropyFS() {
        }

        public String getEntropyInjectionKey() {
            return null;
        }

        public String generateEntropy() {
            return null;
        }
    }
}

