/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.TestTaskStateManager;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.inmemory.InMemoryStateChangelogStorage;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.TestCheckpointResponder;
import org.apache.flink.util.Preconditions;

public class TestTaskStateManagerBuilder {
    private JobID jobID = new JobID();
    private ExecutionAttemptID executionAttemptID = new ExecutionAttemptID();
    private CheckpointResponder checkpointResponder = new TestCheckpointResponder();
    private LocalRecoveryConfig localRecoveryConfig = TestLocalRecoveryConfig.disabled();
    @Nullable
    private StateChangelogStorage<?> stateChangelogStorage = new InMemoryStateChangelogStorage();
    private final Map<Long, TaskStateSnapshot> jobManagerTaskStateSnapshotsByCheckpointId = new HashMap<Long, TaskStateSnapshot>();
    private long reportedCheckpointId = -1L;
    private OneShotLatch waitForReportLatch = new OneShotLatch();

    public TestTaskStateManagerBuilder setJobID(JobID jobID) {
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        return this;
    }

    public TestTaskStateManagerBuilder setExecutionAttemptID(ExecutionAttemptID executionAttemptID) {
        this.executionAttemptID = (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionAttemptID);
        return this;
    }

    public TestTaskStateManagerBuilder setCheckpointResponder(CheckpointResponder checkpointResponder) {
        this.checkpointResponder = (CheckpointResponder)Preconditions.checkNotNull((Object)checkpointResponder);
        return this;
    }

    public TestTaskStateManagerBuilder setLocalRecoveryConfig(LocalRecoveryConfig localRecoveryConfig) {
        this.localRecoveryConfig = (LocalRecoveryConfig)Preconditions.checkNotNull((Object)localRecoveryConfig);
        return this;
    }

    public TestTaskStateManagerBuilder setStateChangelogStorage(StateChangelogStorage<?> stateChangelogStorage) {
        Preconditions.checkState((this.stateChangelogStorage == null || this.stateChangelogStorage instanceof InMemoryStateChangelogStorage ? 1 : 0) != 0, (Object)("StateChangelogStorage was already initialized to " + this.stateChangelogStorage));
        this.stateChangelogStorage = stateChangelogStorage;
        return this;
    }

    public TestTaskStateManagerBuilder setJobManagerTaskStateSnapshotsByCheckpointId(Map<Long, TaskStateSnapshot> jobManagerTaskStateSnapshotsByCheckpointId) {
        this.jobManagerTaskStateSnapshotsByCheckpointId.clear();
        this.jobManagerTaskStateSnapshotsByCheckpointId.putAll(jobManagerTaskStateSnapshotsByCheckpointId);
        return this;
    }

    public TestTaskStateManagerBuilder setReportedCheckpointId(long reportedCheckpointId) {
        this.reportedCheckpointId = reportedCheckpointId;
        return this;
    }

    public TestTaskStateManagerBuilder setWaitForReportLatch(OneShotLatch waitForReportLatch) {
        this.waitForReportLatch = (OneShotLatch)Preconditions.checkNotNull((Object)waitForReportLatch);
        return this;
    }

    public TestTaskStateManager build() {
        return new TestTaskStateManager(this.jobID, this.executionAttemptID, this.checkpointResponder, this.localRecoveryConfig, this.stateChangelogStorage, this.jobManagerTaskStateSnapshotsByCheckpointId, this.reportedCheckpointId, this.waitForReportLatch);
    }
}

