/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.util.Preconditions;

public class TestingSchedulingResultPartition
implements SchedulingResultPartition {
    private final IntermediateDataSetID intermediateDataSetID;
    private final IntermediateResultPartitionID intermediateResultPartitionID;
    private final ResultPartitionType partitionType;
    private TestingSchedulingExecutionVertex producer;
    @Nullable
    private ConsumerVertexGroup consumerVertexGroup;
    private final List<ConsumedPartitionGroup> consumedPartitionGroups;
    private ResultPartitionState state;

    private TestingSchedulingResultPartition(IntermediateDataSetID dataSetID, int partitionNum, ResultPartitionType type, ResultPartitionState state) {
        this.intermediateDataSetID = dataSetID;
        this.partitionType = type;
        this.state = state;
        this.intermediateResultPartitionID = new IntermediateResultPartitionID(dataSetID, partitionNum);
        this.consumedPartitionGroups = new ArrayList<ConsumedPartitionGroup>();
    }

    public IntermediateResultPartitionID getId() {
        return this.intermediateResultPartitionID;
    }

    public IntermediateDataSetID getResultId() {
        return this.intermediateDataSetID;
    }

    public ResultPartitionType getResultType() {
        return this.partitionType;
    }

    public ResultPartitionState getState() {
        return this.state;
    }

    public TestingSchedulingExecutionVertex getProducer() {
        return this.producer;
    }

    public Optional<ConsumerVertexGroup> getConsumerVertexGroup() {
        return Optional.of(this.consumerVertexGroup);
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return Collections.unmodifiableList(this.consumedPartitionGroups);
    }

    void addConsumerGroup(Collection<TestingSchedulingExecutionVertex> consumerVertices) {
        ConsumerVertexGroup consumerVertexGroup;
        Preconditions.checkState((this.consumerVertexGroup == null ? 1 : 0) != 0);
        this.consumerVertexGroup = consumerVertexGroup = ConsumerVertexGroup.fromMultipleVertices(consumerVertices.stream().map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toList()));
    }

    void registerConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup) {
        this.consumedPartitionGroups.add(consumedPartitionGroup);
        if (this.getState() == ResultPartitionState.CONSUMABLE) {
            consumedPartitionGroup.partitionFinished();
        }
    }

    void setProducer(TestingSchedulingExecutionVertex producer) {
        this.producer = (TestingSchedulingExecutionVertex)Preconditions.checkNotNull((Object)producer);
    }

    void markFinished() {
        for (ConsumedPartitionGroup consumedPartitionGroup : this.consumedPartitionGroups) {
            consumedPartitionGroup.partitionFinished();
        }
        this.setState(ResultPartitionState.CONSUMABLE);
    }

    void setState(ResultPartitionState state) {
        this.state = state;
    }

    public static final class Builder {
        private IntermediateDataSetID intermediateDataSetId = new IntermediateDataSetID();
        private int partitionNum = 0;
        private ResultPartitionType resultPartitionType = ResultPartitionType.BLOCKING;
        private ResultPartitionState resultPartitionState = ResultPartitionState.CONSUMABLE;

        Builder withIntermediateDataSetID(IntermediateDataSetID intermediateDataSetId) {
            this.intermediateDataSetId = intermediateDataSetId;
            return this;
        }

        Builder withResultPartitionState(ResultPartitionState state) {
            this.resultPartitionState = state;
            return this;
        }

        Builder withResultPartitionType(ResultPartitionType type) {
            this.resultPartitionType = type;
            return this;
        }

        Builder withPartitionNum(int partitionNum) {
            this.partitionNum = partitionNum;
            return this;
        }

        TestingSchedulingResultPartition build() {
            return new TestingSchedulingResultPartition(this.intermediateDataSetId, this.partitionNum, this.resultPartitionType, this.resultPartitionState);
        }
    }
}

