/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.scheduler.DefaultExecutionGraphFactory;
import org.apache.flink.runtime.scheduler.ExecutionGraphFactory;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.scheduler.adaptivebatch.AdaptiveBatchScheduler;
import org.apache.flink.runtime.scheduler.adaptivebatch.VertexParallelismDecider;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.scheduler.strategy.VertexwiseSchedulingStrategy;

public class AdaptiveBatchSchedulerTestUtils {

    public static class AdaptiveBatchSchedulerBuilder
    extends SchedulerTestingUtils.DefaultSchedulerBuilder {
        private VertexParallelismDecider vertexParallelismDecider = ignored -> 0;
        private int defaultMaxParallelism = (Integer)JobManagerOptions.ADAPTIVE_BATCH_SCHEDULER_MAX_PARALLELISM.defaultValue();

        public AdaptiveBatchSchedulerBuilder(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor) {
            super(jobGraph, mainThreadExecutor);
            this.setSchedulingStrategyFactory((SchedulingStrategyFactory)new VertexwiseSchedulingStrategy.Factory());
        }

        public void setVertexParallelismDecider(VertexParallelismDecider vertexParallelismDecider) {
            this.vertexParallelismDecider = vertexParallelismDecider;
        }

        public void setDefaultMaxParallelism(int defaultMaxParallelism) {
            this.defaultMaxParallelism = defaultMaxParallelism;
        }

        public AdaptiveBatchScheduler build() throws Exception {
            DefaultExecutionGraphFactory executionGraphFactory = new DefaultExecutionGraphFactory(this.jobMasterConfiguration, this.userCodeLoader, (ExecutionDeploymentTracker)new DefaultExecutionDeploymentTracker(), this.futureExecutor, this.ioExecutor, this.rpcTimeout, this.jobManagerJobMetricGroup, this.blobWriter, this.shuffleMaster, this.partitionTracker, true);
            return new AdaptiveBatchScheduler(this.log, this.jobGraph, this.ioExecutor, this.jobMasterConfiguration, componentMainThreadExecutor -> {}, this.delayExecutor, this.userCodeLoader, this.checkpointCleaner, this.checkpointRecoveryFactory, this.jobManagerJobMetricGroup, this.schedulingStrategyFactory, this.failoverStrategyFactory, this.restartBackoffTimeStrategy, this.executionVertexOperations, this.executionVertexVersioner, this.executionSlotAllocatorFactory, System.currentTimeMillis(), this.mainThreadExecutor, this.jobStatusListener, (ExecutionGraphFactory)executionGraphFactory, this.shuffleMaster, this.rpcTimeout, this.vertexParallelismDecider, this.defaultMaxParallelism);
        }
    }
}

