/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.executiongraph.failover.flip1.ResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.scheduler.InternalFailuresListener;
import org.apache.flink.runtime.scheduler.exceptionhistory.TestingAccessExecution;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTrackingMockExecutionGraph
implements ExecutionGraph {
    private static final Logger LOG = LoggerFactory.getLogger(StateTrackingMockExecutionGraph.class);
    private JobStatus state = JobStatus.INITIALIZING;
    private final CompletableFuture<JobStatus> terminationFuture = new CompletableFuture();
    private final JobID jobId = new JobID();
    private static final ArchivedExecutionConfig archivedExecutionConfig = new ExecutionConfig().archive();
    private final Map<ExecutionAttemptID, TestingAccessExecution> executions = new HashMap<ExecutionAttemptID, TestingAccessExecution>();

    StateTrackingMockExecutionGraph() {
    }

    private void transitionToState(JobStatus targetState) {
        if (!this.state.isTerminalState()) {
            this.state = targetState;
        } else {
            LOG.warn("Trying to transition into state {} while being in terminal state {}", (Object)targetState, (Object)this.state);
        }
    }

    void completeTerminationFuture(JobStatus finalStatus) {
        this.terminationFuture.complete(finalStatus);
        this.transitionToState(finalStatus);
    }

    public boolean updateState(TaskExecutionStateTransition state) {
        return true;
    }

    public JobStatus getState() {
        return this.state;
    }

    public CompletableFuture<JobStatus> getTerminationFuture() {
        return this.terminationFuture;
    }

    public void cancel() {
        this.transitionToState(JobStatus.CANCELLING);
    }

    public void failJob(Throwable cause, long timestamp) {
        this.transitionToState(JobStatus.FAILING);
    }

    public void suspend(Throwable suspensionCause) {
        this.transitionToState(JobStatus.SUSPENDED);
    }

    public void transitionToRunning() {
        this.transitionToState(JobStatus.RUNNING);
    }

    public Iterable<ExecutionJobVertex> getVerticesTopologically() {
        return Collections.emptyList();
    }

    public Map<JobVertexID, ExecutionJobVertex> getAllVertices() {
        return Collections.emptyMap();
    }

    public Map<String, SerializedValue<OptionalFailure<Object>>> getAccumulatorsSerialized() {
        return Collections.emptyMap();
    }

    public long getStatusTimestamp(JobStatus status) {
        return 0L;
    }

    public String getJsonPlan() {
        return "";
    }

    public void setJsonPlan(String jsonPlan) {
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public String getJobName() {
        return "testJob";
    }

    @Nullable
    public ErrorInfo getFailureInfo() {
        return null;
    }

    @Nullable
    public ArchivedExecutionConfig getArchivedExecutionConfig() {
        return archivedExecutionConfig;
    }

    public boolean isStoppable() {
        return false;
    }

    @Nullable
    public CheckpointCoordinatorConfiguration getCheckpointCoordinatorConfiguration() {
        return null;
    }

    @Nullable
    public CheckpointStatsSnapshot getCheckpointStatsSnapshot() {
        return null;
    }

    public Optional<String> getStateBackendName() {
        return Optional.empty();
    }

    public Optional<String> getCheckpointStorageName() {
        return Optional.empty();
    }

    public StringifiedAccumulatorResult[] getAccumulatorResultsStringified() {
        return new StringifiedAccumulatorResult[0];
    }

    public Iterable<ExecutionVertex> getAllExecutionVertices() {
        return Collections.emptyList();
    }

    public Map<ExecutionAttemptID, Execution> getRegisteredExecutions() {
        return Collections.emptyMap();
    }

    public void start(@Nonnull ComponentMainThreadExecutor jobMasterMainThreadExecutor) {
    }

    public void setInternalTaskFailuresListener(InternalFailuresListener internalTaskFailuresListener) {
    }

    public SchedulingTopology getSchedulingTopology() {
        return new TestingSchedulingTopology();
    }

    public void enableCheckpointing(CheckpointCoordinatorConfiguration chkConfig, List<MasterTriggerRestoreHook<?>> masterHooks, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore checkpointStore, StateBackend checkpointStateBackend, CheckpointStorage checkpointStorage, CheckpointStatsTracker statsTracker, CheckpointsCleaner checkpointsCleaner) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public CheckpointCoordinator getCheckpointCoordinator() {
        throw new UnsupportedOperationException();
    }

    public KvStateLocationRegistry getKvStateLocationRegistry() {
        throw new UnsupportedOperationException();
    }

    public Configuration getJobConfiguration() {
        throw new UnsupportedOperationException();
    }

    public Throwable getFailureCause() {
        throw new UnsupportedOperationException();
    }

    public ExecutionJobVertex getJobVertex(JobVertexID id) {
        throw new UnsupportedOperationException();
    }

    public long getNumberOfRestarts() {
        throw new UnsupportedOperationException();
    }

    public Map<IntermediateDataSetID, IntermediateResult> getAllIntermediateResults() {
        throw new UnsupportedOperationException();
    }

    public Map<String, OptionalFailure<Accumulator<?, ?>>> aggregateUserAccumulators() {
        throw new UnsupportedOperationException();
    }

    public void attachJobGraph(List<JobVertex> topologicallySorted) throws JobException {
        throw new UnsupportedOperationException();
    }

    public JobStatus waitUntilTerminal() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public boolean transitionState(JobStatus current, JobStatus newState) {
        throw new UnsupportedOperationException();
    }

    public void incrementRestarts() {
        throw new UnsupportedOperationException();
    }

    public void initFailureCause(Throwable t, long timestamp) {
        throw new UnsupportedOperationException();
    }

    public void notifyPartitionDataAvailable(ResultPartitionID partitionId) {
        throw new UnsupportedOperationException();
    }

    public void updateAccumulators(AccumulatorSnapshot accumulatorSnapshot) {
        throw new UnsupportedOperationException();
    }

    public void registerJobStatusListener(JobStatusListener listener) {
        throw new UnsupportedOperationException();
    }

    public ResultPartitionAvailabilityChecker getResultPartitionAvailabilityChecker() {
        throw new UnsupportedOperationException();
    }

    public int getNumFinishedVertices() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public ComponentMainThreadExecutor getJobMasterMainThreadExecutor() {
        throw new UnsupportedOperationException();
    }

    public void initializeJobVertex(ExecutionJobVertex ejv, long createTimestamp) throws JobException {
        throw new UnsupportedOperationException();
    }

    public void notifyNewlyInitializedJobVertices(List<ExecutionJobVertex> vertices) {
        throw new UnsupportedOperationException();
    }

    public void registerExecution(TestingAccessExecution execution) {
        this.executions.put(execution.getAttemptId(), execution);
    }

    public Optional<String> findVertexWithAttempt(ExecutionAttemptID attemptId) {
        return Optional.of("dummy");
    }

    public Optional<AccessExecution> findExecution(ExecutionAttemptID attemptId) {
        return Optional.ofNullable(this.executions.get(attemptId));
    }
}

